/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.extractor.html;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.any23.extractor.ExtractionContext;
import org.apache.any23.extractor.ExtractionException;
import org.apache.any23.extractor.ExtractionParameters;
import org.apache.any23.extractor.ExtractionResult;
import org.apache.any23.extractor.Extractor;
import org.apache.any23.extractor.ExtractorDescription;
import org.apache.any23.extractor.html.DomUtils;
import org.apache.any23.extractor.html.HTMLMetaExtractorFactory;
import org.apache.any23.rdf.RDFUtils;
import org.apache.any23.vocab.SINDICE;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class HTMLMetaExtractor
implements Extractor.TagSoupDOMExtractor {
    private static final SINDICE vSINDICE = SINDICE.getInstance();
    private IRI profile;
    private Map<String, IRI> prefixes = new HashMap<String, IRI>();
    private String documentLang;

    public void run(ExtractionParameters extractionParameters, ExtractionContext extractionContext, Document in, ExtractionResult out) throws IOException, ExtractionException {
        this.profile = this.extractProfile(in);
        this.documentLang = this.getDocumentLanguage(in);
        this.extractLinkDefinedPrefixes(in);
        String baseProfile = "http://vocab.sindice.net/any23#";
        if (this.profile != null) {
            baseProfile = this.profile.toString();
        }
        IRI documentIRI = extractionContext.getDocumentIRI();
        Set<Meta> metas = this.extractMetaElement(in, baseProfile);
        for (Meta meta : metas) {
            String lang = this.documentLang;
            if (meta.getLang() != null) {
                lang = meta.getLang();
            }
            if (meta.isPragmaDirective) {
                if (lang != null) {
                    out.writeTriple((Resource)documentIRI, meta.getHttpEquiv(), (Value)SimpleValueFactory.getInstance().createLiteral(meta.getContent(), lang));
                    continue;
                }
                out.writeTriple((Resource)documentIRI, meta.getHttpEquiv(), (Value)SimpleValueFactory.getInstance().createLiteral(meta.getContent()));
                continue;
            }
            if (lang != null) {
                out.writeTriple((Resource)documentIRI, meta.getName(), (Value)SimpleValueFactory.getInstance().createLiteral(meta.getContent(), lang));
                continue;
            }
            out.writeTriple((Resource)documentIRI, meta.getName(), (Value)SimpleValueFactory.getInstance().createLiteral(meta.getContent()));
        }
    }

    private String getDocumentLanguage(Document in) {
        String lang = DomUtils.find(in, "string(/HTML/@lang)");
        if ("".equals(lang)) {
            return null;
        }
        return lang;
    }

    private IRI extractProfile(Document in) {
        String profile = DomUtils.find(in, "string(/HTML/@profile)");
        if ("".equals(profile)) {
            return null;
        }
        return SimpleValueFactory.getInstance().createIRI(profile);
    }

    private void extractLinkDefinedPrefixes(Document in) {
        List<Node> linkNodes = DomUtils.findAll(in, "/HTML/HEAD/LINK");
        for (Node linkNode : linkNodes) {
            String href;
            NamedNodeMap attributes = linkNode.getAttributes();
            Node relNode = attributes.getNamedItem("rel");
            String rel = relNode == null ? null : relNode.getTextContent();
            Node hrefNode = attributes.getNamedItem("href");
            String string = href = hrefNode == null ? null : hrefNode.getTextContent();
            if (rel == null || href == null || !RDFUtils.isAbsoluteIRI(href)) continue;
            this.prefixes.put(rel, SimpleValueFactory.getInstance().createIRI(href));
        }
    }

    private Set<Meta> extractMetaElement(Document in, String baseProfile) {
        List<Node> metaNodes = DomUtils.findAll(in, "/HTML/HEAD/META");
        HashSet<Meta> result = new HashSet<Meta>();
        for (Node metaNode : metaNodes) {
            Meta meta;
            String xpath;
            String content;
            boolean isPragmaDirective;
            NamedNodeMap attributes = metaNode.getAttributes();
            Node nameAttribute = attributes.getNamedItem("name");
            Node httpEquivAttribute = attributes.getNamedItem("http-equiv");
            Node contentAttribute = attributes.getNamedItem("content");
            if (nameAttribute == null && httpEquivAttribute == null || (nameAttribute != null || httpEquivAttribute != null) && contentAttribute == null) continue;
            boolean bl = isPragmaDirective = httpEquivAttribute != null;
            if (isPragmaDirective) {
                String httpEquiv = httpEquivAttribute.getTextContent();
                content = contentAttribute.getTextContent();
                xpath = DomUtils.getXPathForNode(metaNode);
                IRI httpEquivAsIRI = this.getPrefixIfExists(httpEquiv);
                if (httpEquivAsIRI == null) {
                    httpEquivAsIRI = SimpleValueFactory.getInstance().createIRI(baseProfile + httpEquiv);
                }
                meta = new Meta(xpath, content, httpEquivAsIRI);
                result.add(meta);
                continue;
            }
            String name = nameAttribute.getTextContent();
            content = contentAttribute.getTextContent();
            xpath = DomUtils.getXPathForNode(metaNode);
            IRI nameAsIRI = this.getPrefixIfExists(name);
            if (nameAsIRI == null) {
                nameAsIRI = SimpleValueFactory.getInstance().createIRI(baseProfile + name);
            }
            meta = new Meta(xpath, nameAsIRI, content);
            result.add(meta);
        }
        return result;
    }

    private IRI getPrefixIfExists(String name) {
        String[] split = name.split("\\.");
        if (split.length == 2 && this.prefixes.containsKey(split[0])) {
            return SimpleValueFactory.getInstance().createIRI(this.prefixes.get(split[0]) + split[1]);
        }
        return null;
    }

    public ExtractorDescription getDescription() {
        return HTMLMetaExtractorFactory.getDescriptionInstance();
    }

    private static class Meta {
        private String xpath;
        private IRI name;
        private IRI httpEquiv;
        private String lang;
        private String content;
        private boolean isPragmaDirective;

        public Meta(String xpath, String content, IRI httpEquiv) {
            this.xpath = xpath;
            this.content = content;
            this.httpEquiv = httpEquiv;
            this.setPragmaDirective(true);
        }

        public Meta(String xpath, String content, IRI httpEquiv, String lang) {
            this(xpath, content, httpEquiv);
            this.lang = lang;
        }

        public Meta(String xpath, IRI name, String content) {
            this.xpath = xpath;
            this.name = name;
            this.content = content;
        }

        public Meta(String xpath, IRI name, String content, String lang) {
            this(xpath, name, content);
            this.lang = lang;
        }

        private void setPragmaDirective(boolean value) {
            this.isPragmaDirective = value;
        }

        public IRI getHttpEquiv() {
            return this.httpEquiv;
        }

        public IRI getName() {
            return this.name;
        }

        public String getLang() {
            return this.lang;
        }

        public String getContent() {
            return this.content;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Meta meta = (Meta)o;
            return !(this.xpath != null ? !this.xpath.equals(meta.xpath) : meta.xpath != null);
        }

        public int hashCode() {
            return this.xpath != null ? this.xpath.hashCode() : 0;
        }
    }
}

