/*
 * Decompiled with CFR 0.152.
 */
package org.rypt.f8;

import java.io.IOException;
import org.rypt.f8.Utf8;
import org.rypt.f8.Utf8ByteHandler;

public interface Utf8Handler<X extends Exception>
extends Utf8ByteHandler<X> {
    public void handleCodePoint(int var1) throws X;

    public void handleError() throws X;

    @Override
    default public void handle1ByteCodePoint(int ascii) throws X {
        this.handleCodePoint(ascii);
    }

    @Override
    default public void handle2ByteCodePoint(int b1, int b2) throws X {
        this.handleCodePoint(Utf8.codePoint(b1, b2));
    }

    @Override
    default public void handle3ByteCodePoint(int b1, int b2, int b3) throws X {
        this.handleCodePoint(Utf8.codePoint(b1, b2, b3));
    }

    @Override
    default public void handle4ByteCodePoint(int b1, int b2, int b3, int b4) throws X {
        this.handleCodePoint(Utf8.codePoint(b1, b2, b3, b4));
    }

    @Override
    default public void handleContinuationError(int b1, int nextByte) throws X {
        this.handleError();
    }

    @Override
    default public void handleContinuationError(int b1, int b2, int nextByte) throws X {
        this.handleError();
    }

    @Override
    default public void handleContinuationError(int b1, int b2, int b3, int nextByte) throws X {
        this.handleError();
    }

    @Override
    default public void handlePrefixError(int b1) throws X {
        this.handleError();
    }

    public static Utf8Handler<IOException> of(final Appendable writer) {
        return new Utf8Handler<IOException>(){

            @Override
            public void handleCodePoint(int codePoint) throws IOException {
                if (Character.isBmpCodePoint(codePoint)) {
                    writer.append((char)codePoint);
                } else {
                    writer.append(Character.highSurrogate(codePoint));
                    writer.append(Character.lowSurrogate(codePoint));
                }
            }

            @Override
            public void handleError() throws IOException {
                writer.append('\ufffd');
            }

            @Override
            public void handle1ByteCodePoint(int ascii) throws IOException {
                writer.append((char)ascii);
            }

            @Override
            public void handle2ByteCodePoint(int b1, int b2) throws IOException {
                writer.append((char)Utf8.codePoint(b1, b2));
            }

            @Override
            public void handle3ByteCodePoint(int b1, int b2, int b3) throws IOException {
                writer.append((char)Utf8.codePoint(b1, b2, b3));
            }

            @Override
            public void handle4ByteCodePoint(int b1, int b2, int b3, int b4) throws IOException {
                int cp = Utf8.codePoint(b1, b2, b3, b4);
                writer.append(Character.highSurrogate(cp));
                writer.append(Character.lowSurrogate(cp));
            }
        };
    }
}

