/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.blip;

import java.awt.Dimension;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.InflaterInputStream;
import org.apache.commons.io.output.UnsynchronizedByteArrayOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Unbox;
import org.apache.poi.ddf.EscherBSERecord;
import org.apache.poi.ddf.EscherContainerRecord;
import org.apache.poi.hslf.blip.Metafile;
import org.apache.poi.hslf.exceptions.HSLFException;
import org.apache.poi.sl.image.ImageHeaderPICT;
import org.apache.poi.sl.usermodel.PictureData;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.Internal;
import org.apache.poi.util.Removal;
import org.apache.poi.util.Units;

public final class PICT
extends Metafile {
    private static final Logger LOG = LogManager.getLogger(PICT.class);

    @Deprecated
    @Removal(version="5.3")
    public PICT() {
        this(new EscherContainerRecord(), new EscherBSERecord());
    }

    @Internal
    public PICT(EscherContainerRecord recordContainer, EscherBSERecord bse) {
        super(recordContainer, bse);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getData() {
        byte[] rawdata = this.getRawData();
        try (UnsynchronizedByteArrayOutputStream out = new UnsynchronizedByteArrayOutputStream();){
            byte[] macheader = new byte[512];
            out.write(macheader);
            int pos = 16 * this.getUIDInstanceCount();
            byte[] pict = this.read(rawdata, pos);
            out.write(pict);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new HSLFException(e);
        }
    }

    private byte[] read(byte[] data, int pos) throws IOException {
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        Metafile.Header header = new Metafile.Header();
        header.read(data, pos);
        long bs_exp = (long)pos + (long)header.getSize();
        long bs_act = IOUtils.skipFully((InputStream)bis, (long)bs_exp);
        if (bs_exp != bs_act) {
            throw new EOFException();
        }
        byte[] chunk = new byte[4096];
        try (UnsynchronizedByteArrayOutputStream out = new UnsynchronizedByteArrayOutputStream(header.getWmfSize());){
            try (InflaterInputStream inflater = new InflaterInputStream(bis);){
                int count;
                while ((count = inflater.read(chunk)) >= 0) {
                    out.write(chunk, 0, count);
                    PICT.bytefill(chunk, (byte)0);
                }
            }
            catch (Exception e) {
                int lastLen;
                for (lastLen = chunk.length - 1; lastLen >= 0 && chunk[lastLen] == 0; --lastLen) {
                }
                if (++lastLen > 0) {
                    if (header.getWmfSize() > out.size()) {
                        lastLen = Math.min(lastLen, header.getWmfSize() - out.size());
                    }
                    out.write(chunk, 0, lastLen);
                }
                LOG.atError().withThrowable((Throwable)e).log("PICT zip-stream is invalid, read as much as possible. Uncompressed length of header: {} / Read bytes: {}", (Object)Unbox.box((int)header.getWmfSize()), (Object)Unbox.box((int)out.size()));
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }

    @Override
    protected byte[] formatImageForSlideshow(byte[] data) {
        int nOffset = 512;
        ImageHeaderPICT nHeader = new ImageHeaderPICT(data, 512);
        Metafile.Header header = new Metafile.Header();
        int wmfSize = data.length - 512;
        header.setWmfSize(wmfSize);
        byte[] compressed = PICT.compress(data, 512, wmfSize);
        header.setZipSize(compressed.length);
        header.setBounds(nHeader.getBounds());
        Dimension nDim = nHeader.getSize();
        header.setDimension(new Dimension(Units.toEMU((double)nDim.getWidth()), Units.toEMU((double)nDim.getHeight())));
        byte[] checksum = PICT.getChecksum(data);
        byte[] rawData = new byte[checksum.length * this.getUIDInstanceCount() + header.getSize() + compressed.length];
        int offset = 0;
        System.arraycopy(checksum, 0, rawData, offset, checksum.length);
        offset += checksum.length;
        if (this.getUIDInstanceCount() == 2) {
            System.arraycopy(checksum, 0, rawData, offset, checksum.length);
            offset += checksum.length;
        }
        header.write(rawData, offset);
        System.arraycopy(compressed, 0, rawData, offset += header.getSize(), compressed.length);
        return rawData;
    }

    public PictureData.PictureType getType() {
        return PictureData.PictureType.PICT;
    }

    @Override
    public int getSignature() {
        return this.getUIDInstanceCount() == 1 ? 21536 : 21552;
    }

    @Override
    public void setSignature(int signature) {
        switch (signature) {
            case 21536: {
                this.setUIDInstanceCount(1);
                break;
            }
            case 21552: {
                this.setUIDInstanceCount(2);
                break;
            }
            default: {
                throw new IllegalArgumentException(signature + " is not a valid instance/signature value for PICT");
            }
        }
    }

    private static void bytefill(byte[] array, byte value) {
        int len = array.length;
        if (len > 0) {
            array[0] = value;
        }
        for (int i = 1; i < len; i += i) {
            System.arraycopy(array, 0, array, i, Math.min(len - i, i));
        }
    }
}

