/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.writer;

import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.any23.extractor.ExtractionContext;
import org.apache.any23.writer.TripleHandler;
import org.apache.any23.writer.TripleHandlerException;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;

public class ReportingTripleHandler
implements TripleHandler {
    private final TripleHandler wrapped;
    private final Collection<String> extractorNames = new HashSet<String>();
    private AtomicInteger totalTriples = new AtomicInteger(0);
    private AtomicInteger totalDocuments = new AtomicInteger(0);

    public ReportingTripleHandler(TripleHandler wrapped) {
        if (wrapped == null) {
            throw new NullPointerException("wrapped cannot be null.");
        }
        this.wrapped = wrapped;
    }

    public Collection<String> getExtractorNames() {
        return this.extractorNames;
    }

    public int getTotalTriples() {
        return this.totalTriples.get();
    }

    public int getTotalDocuments() {
        return this.totalDocuments.get();
    }

    public String printReport() {
        return String.format(Locale.ROOT, "Total Documents: %d, Total Triples: %d", this.getTotalDocuments(), this.getTotalTriples());
    }

    public void startDocument(IRI documentIRI) throws TripleHandlerException {
        this.totalDocuments.incrementAndGet();
        this.wrapped.startDocument(documentIRI);
    }

    public void openContext(ExtractionContext context) throws TripleHandlerException {
        this.wrapped.openContext(context);
    }

    public void receiveNamespace(String prefix, String uri, ExtractionContext context) throws TripleHandlerException {
        this.wrapped.receiveNamespace(prefix, uri, context);
    }

    public void receiveTriple(Resource s, IRI p, Value o, IRI g, ExtractionContext context) throws TripleHandlerException {
        this.extractorNames.add(context.getExtractorName());
        this.totalTriples.incrementAndGet();
        this.wrapped.receiveTriple(s, p, o, g, context);
    }

    public void setContentLength(long contentLength) {
        this.wrapped.setContentLength(contentLength);
    }

    public void closeContext(ExtractionContext context) throws TripleHandlerException {
        this.wrapped.closeContext(context);
    }

    public void endDocument(IRI documentIRI) throws TripleHandlerException {
        this.wrapped.endDocument(documentIRI);
    }

    public void close() throws TripleHandlerException {
        this.wrapped.close();
    }
}

