/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.writer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.any23.extractor.ExtractionContext;
import org.apache.any23.writer.TripleHandler;
import org.apache.any23.writer.TripleHandlerException;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;

public class CompositeTripleHandler
implements TripleHandler {
    private Collection<TripleHandler> children = new ArrayList<TripleHandler>();

    public CompositeTripleHandler() {
        this(Collections.emptyList());
    }

    public CompositeTripleHandler(Collection<TripleHandler> children) {
        this.children.addAll(children);
    }

    public void addChild(TripleHandler child) {
        this.children.add(child);
    }

    public Collection<TripleHandler> getChilds() {
        return this.children;
    }

    public void startDocument(IRI documentIRI) throws TripleHandlerException {
        for (TripleHandler handler : this.children) {
            handler.startDocument(documentIRI);
        }
    }

    public void openContext(ExtractionContext context) throws TripleHandlerException {
        for (TripleHandler handler : this.children) {
            handler.openContext(context);
        }
    }

    public void closeContext(ExtractionContext context) throws TripleHandlerException {
        for (TripleHandler handler : this.children) {
            handler.closeContext(context);
        }
    }

    public void receiveTriple(Resource s, IRI p, Value o, IRI g, ExtractionContext context) throws TripleHandlerException {
        for (TripleHandler handler : this.children) {
            handler.receiveTriple(s, p, o, g, context);
        }
    }

    public void receiveNamespace(String prefix, String uri, ExtractionContext context) throws TripleHandlerException {
        for (TripleHandler handler : this.children) {
            handler.receiveNamespace(prefix, uri, context);
        }
    }

    public void close() throws TripleHandlerException {
        for (TripleHandler handler : this.children) {
            handler.close();
        }
    }

    public void endDocument(IRI documentIRI) throws TripleHandlerException {
        for (TripleHandler handler : this.children) {
            handler.endDocument(documentIRI);
        }
    }

    public void setContentLength(long contentLength) {
        for (TripleHandler handler : this.children) {
            handler.setContentLength(contentLength);
        }
    }
}

