/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.validator.rule;

import java.util.ArrayList;
import java.util.List;
import org.apache.any23.validator.DOMDocument;
import org.apache.any23.validator.Rule;
import org.apache.any23.validator.RuleContext;
import org.apache.any23.validator.ValidationReport;
import org.apache.any23.validator.ValidationReportBuilder;
import org.w3c.dom.Node;

public class MetaNameMisuseRule
implements Rule {
    public static final String ERRORED_META_NODES = "errored-meta-nodes";

    @Override
    public String getHRName() {
        return "meta-name-misuse-rule";
    }

    public boolean applyOn(DOMDocument document, RuleContext context, ValidationReportBuilder validationReportBuilder) {
        List<Node> metaNodes = document.getNodes("/HTML/HEAD/META");
        boolean foundIssue = false;
        ArrayList<Node> wrongMetaNodes = new ArrayList<Node>();
        for (Node metaNode : metaNodes) {
            Node nameNode = metaNode.getAttributes().getNamedItem("name");
            if (nameNode == null || !nameNode.getTextContent().contains(":")) continue;
            foundIssue = true;
            wrongMetaNodes.add(metaNode);
            validationReportBuilder.reportIssue(ValidationReport.IssueLevel.ERROR, "Error detected in meta node: name property contains a prefixed value.", metaNode);
        }
        context.putData(ERRORED_META_NODES, wrongMetaNodes);
        return foundIssue;
    }
}

