/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.validator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.any23.validator.DefaultValidationReport;
import org.apache.any23.validator.Fix;
import org.apache.any23.validator.Rule;
import org.apache.any23.validator.ValidationReport;
import org.apache.any23.validator.ValidationReportBuilder;
import org.w3c.dom.Node;

public class DefaultValidationReportBuilder
implements ValidationReportBuilder {
    private List<ValidationReport.Issue> issues;
    private List<ValidationReport.RuleActivation> ruleActivations;
    private List<ValidationReport.Error> errors;

    @Override
    public ValidationReport getReport() {
        return new DefaultValidationReport(this.issues == null ? Collections.emptyList() : this.issues, this.ruleActivations == null ? Collections.emptyList() : this.ruleActivations, this.errors == null ? Collections.emptyList() : this.errors);
    }

    @Override
    public void reportIssue(ValidationReport.IssueLevel issueLevel, String message, Node n) {
        if (this.issues == null) {
            this.issues = new ArrayList<ValidationReport.Issue>();
        }
        this.issues.add(new ValidationReport.Issue(issueLevel, message, n));
    }

    @Override
    public void reportIssue(ValidationReport.IssueLevel issueLevel, String message) {
        this.reportIssue(issueLevel, message, null);
    }

    @Override
    public void traceRuleActivation(Rule r) {
        if (this.ruleActivations == null) {
            this.ruleActivations = new ArrayList<ValidationReport.RuleActivation>();
        }
        this.ruleActivations.add(new ValidationReport.RuleActivation(r));
    }

    @Override
    public void reportRuleError(Rule r, Exception e, String msg) {
        if (this.errors == null) {
            this.errors = new ArrayList<ValidationReport.Error>();
        }
        this.errors.add(new ValidationReport.RuleError(r, e, msg));
    }

    @Override
    public void reportFixError(Fix f, Exception e, String msg) {
        if (this.errors == null) {
            this.errors = new ArrayList<ValidationReport.Error>();
        }
        this.errors.add(new ValidationReport.FixError(f, e, msg));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.ruleActivations != null) {
            sb.append("Rules {\n");
            for (ValidationReport.RuleActivation ra : this.ruleActivations) {
                sb.append(ra).append('\n');
            }
            sb.append("}\n");
        }
        if (this.issues != null) {
            sb.append("Issues {\n");
            for (ValidationReport.Issue issue : this.issues) {
                sb.append(issue.toString()).append('\n');
            }
            sb.append("}\n");
        }
        if (this.errors != null) {
            sb.append("Errors {\n");
            for (ValidationReport.Error error : this.errors) {
                sb.append(error.toString()).append('\n');
            }
            sb.append("}\n");
        }
        return sb.toString();
    }
}

