/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.source;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.any23.source.DocumentSource;
import org.apache.any23.source.MemCopyFactory;

public class ByteArrayDocumentSource
implements DocumentSource {
    private final byte[] bytes;
    private final String documentIRI;
    private final String contentType;

    public ByteArrayDocumentSource(byte[] bytes, String documentIRI, String contentType) {
        this.bytes = bytes;
        this.documentIRI = documentIRI;
        this.contentType = contentType;
    }

    public ByteArrayDocumentSource(InputStream inputStream, String documentIRI, String contentType) throws IOException {
        this(MemCopyFactory.toByteArray(inputStream), documentIRI, contentType);
    }

    public InputStream openInputStream() throws IOException {
        return new ByteArrayInputStream(this.bytes);
    }

    public long getContentLength() {
        return this.bytes.length;
    }

    public String getDocumentIRI() {
        return this.documentIRI;
    }

    public String getContentType() {
        return this.contentType;
    }

    public boolean isLocal() {
        return true;
    }
}

