/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.http;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.any23.http.DefaultHTTPClientConfiguration;
import org.apache.any23.http.HTTPClient;
import org.apache.any23.http.HTTPClientConfiguration;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;

public class DefaultHTTPClient
implements HTTPClient {
    private final PoolingHttpClientConnectionManager manager = new PoolingHttpClientConnectionManager();
    private HTTPClientConfiguration configuration;
    private HttpClient client = null;
    private long _contentLength = -1L;
    private String actualDocumentIRI = null;
    private String contentType = null;

    public static DefaultHTTPClient createInitializedHTTPClient() {
        DefaultHTTPClient defaultHTTPClient = new DefaultHTTPClient();
        defaultHTTPClient.init(DefaultHTTPClientConfiguration.singleton());
        return defaultHTTPClient;
    }

    @Override
    public void init(HTTPClientConfiguration configuration) {
        if (configuration == null) {
            throw new NullPointerException("Illegal configuration, cannot be null.");
        }
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream openInputStream(String uri) throws IOException {
        HttpGet method = null;
        try {
            this.ensureClientInitialized();
            HttpClientContext context = HttpClientContext.create();
            method = new HttpGet(uri);
            HttpResponse response = this.client.execute((HttpUriRequest)method, (HttpContext)context);
            List locations = context.getRedirectLocations();
            URI actualURI = locations == null || locations.isEmpty() ? method.getURI() : (URI)locations.get(locations.size() - 1);
            this.actualDocumentIRI = actualURI.toString();
            Header contentTypeHeader = response.getFirstHeader("Content-Type");
            String string = this.contentType = contentTypeHeader == null ? null : contentTypeHeader.getValue();
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new IOException("Failed to fetch " + uri + ": " + response.getStatusLine().getStatusCode() + " " + response.getStatusLine().getReasonPhrase());
            }
            byte[] bytes = IOUtils.toByteArray((InputStream)response.getEntity().getContent());
            this._contentLength = bytes.length;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
            return byteArrayInputStream;
        }
        finally {
            if (method != null) {
                method.reset();
            }
        }
    }

    @Override
    public void close() {
        this.manager.shutdown();
    }

    @Override
    public long getContentLength() {
        return this._contentLength;
    }

    @Override
    public String getActualDocumentIRI() {
        return this.actualDocumentIRI;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    protected int getConnectionTimeout() {
        return this.configuration.getDefaultTimeout();
    }

    protected int getSoTimeout() {
        return this.configuration.getDefaultTimeout();
    }

    private void ensureClientInitialized() {
        if (this.configuration == null) {
            throw new IllegalStateException("client must be initialized first.");
        }
        if (this.client != null) {
            return;
        }
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(this.getConnectionTimeout()).setSocketTimeout(this.getSoTimeout()).setRedirectsEnabled(true).build();
        SocketConfig socketConfig = SocketConfig.custom().setSoTimeout(this.getSoTimeout()).build();
        ArrayList<BasicHeader> headers = new ArrayList<BasicHeader>();
        headers.add(new BasicHeader("User-Agent", this.configuration.getUserAgent()));
        if (this.configuration.getAcceptHeader() != null) {
            headers.add(new BasicHeader("Accept", this.configuration.getAcceptHeader()));
        }
        headers.add(new BasicHeader("Accept-Language", "en-us,en-gb,en,*;q=0.3"));
        headers.add(new BasicHeader("Accept-Charset", "utf-8,iso-8859-1;q=0.7,*;q=0.5"));
        this.client = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)this.manager).setDefaultRequestConfig(requestConfig).setDefaultSocketConfig(socketConfig).setMaxConnTotal(this.configuration.getMaxConnections()).setDefaultHeaders(headers).build();
    }
}

