/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.extractor.xpath;

import java.util.Locale;
import org.apache.any23.extractor.xpath.Term;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;

public class TemplateObject
extends Term {
    private final Type type;

    public TemplateObject(Type type, String value, boolean isVar) {
        super(value, isVar);
        if (type == null) {
            throw new NullPointerException("object type cannot be null.");
        }
        this.type = type;
    }

    protected Value getValueInternal(String value) {
        switch (this.type) {
            case URI: {
                return this.createIRI(value);
            }
            case BNODE: {
                return SimpleValueFactory.getInstance().createBNode(value);
            }
            case LITERAL: {
                return SimpleValueFactory.getInstance().createLiteral(value);
            }
        }
        throw new IllegalStateException();
    }

    private Value createIRI(String value) {
        try {
            return SimpleValueFactory.getInstance().createIRI(value);
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected a valid IRI for object template, found '%s'", value), iae);
        }
    }

    @Override
    public String toString() {
        String superStr = super.toString();
        switch (this.type) {
            case URI: {
                return "<" + superStr + ">";
            }
            case BNODE: {
                return "_:" + superStr;
            }
            case LITERAL: {
                return "'" + superStr + "'";
            }
        }
        throw new IllegalStateException();
    }

    public static enum Type {
        URI,
        BNODE,
        LITERAL;

    }
}

