/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.extractor.rdfa;

import java.io.InputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.any23.extractor.rdfa.XSLTStylesheetException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class XSLTStylesheet {
    private static final Logger log = LoggerFactory.getLogger(XSLTStylesheet.class);
    private final Transformer transformer;

    public XSLTStylesheet(InputStream xsltFile) {
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            tf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            tf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
            this.transformer = tf.newTransformer(new StreamSource(xsltFile));
        }
        catch (TransformerConfigurationException tce) {
            throw new RuntimeException("Should not happen, we use the default configuration", tce);
        }
    }

    public synchronized void applyTo(Document document, Writer output) throws XSLTStylesheetException {
        this.applyTo(document, output, new HashMap<String, String>());
    }

    public synchronized void applyTo(Document document, Writer output, Map<String, String> parameters) throws XSLTStylesheetException {
        for (String parameterKey : parameters.keySet()) {
            this.transformer.setParameter(parameterKey, parameters.get(parameterKey));
        }
        try {
            this.transformer.transform(new DOMSource(document, document.getBaseURI()), new StreamResult(output));
        }
        catch (TransformerException te) {
            log.error("------ BEGIN XSLT Transformer Exception ------");
            log.error("Exception in XSLT Stylesheet transformation.", (Throwable)te);
            log.error("Input DOM node:", (Object)document);
            log.error("Input DOM node getBaseIRI:", (Object)document.getBaseURI());
            log.error("Output writer:", (Object)output);
            log.error("------ END XSLT Transformer Exception ------");
            throw new XSLTStylesheetException(" An error occurred during the XSLT transformation", te);
        }
    }
}

