/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.extractor.rdfa;

import org.apache.any23.extractor.ExtractionResult;
import org.apache.any23.extractor.IssueReport;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.semarglproject.rdf.ProcessorGraphHandler;
import org.semarglproject.sink.TripleSink;

final class SemarglSink
implements TripleSink,
ProcessorGraphHandler {
    private static final String BNODE_PREFIX = "_:";
    private final ExtractionResult handler;
    private final ValueFactory valueFactory;

    SemarglSink(ExtractionResult handler, ValueFactory valueFactory) {
        this.handler = handler;
        this.valueFactory = valueFactory;
    }

    private Resource createResource(String arg) {
        if (arg.startsWith(BNODE_PREFIX)) {
            return this.valueFactory.createBNode(arg.substring(BNODE_PREFIX.length()));
        }
        return this.valueFactory.createIRI(arg);
    }

    private void writeTriple(String s, String p, Value o) {
        this.handler.writeTriple(this.createResource(s), this.valueFactory.createIRI(p), o);
    }

    public final void addNonLiteral(String s, String p, String o) {
        this.writeTriple(s, p, (Value)this.createResource(o));
    }

    public final void addPlainLiteral(String s, String p, String o, String lang) {
        this.writeTriple(s, p, (Value)(lang == null ? this.valueFactory.createLiteral(o) : this.valueFactory.createLiteral(o, lang)));
    }

    public final void addTypedLiteral(String s, String p, String o, String type) {
        this.writeTriple(s, p, (Value)this.valueFactory.createLiteral(o, this.valueFactory.createIRI(type)));
    }

    public void startStream() {
    }

    public void endStream() {
    }

    public boolean setProperty(String key, Object value) {
        return false;
    }

    public void setBaseUri(String baseUri) {
    }

    public void info(String infoClass, String message) {
    }

    public void warning(String warningClass, String message) {
        this.handler.notifyIssue(IssueReport.IssueLevel.WARNING, message, -1L, -1L);
    }

    public void error(String errorClass, String message) {
        this.handler.notifyIssue(IssueReport.IssueLevel.ERROR, message, -1L, -1L);
    }
}

