/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.extractor.rdf;

import com.github.jsonldjava.core.JsonLdTripleCallback;
import com.github.jsonldjava.core.RDFDataset;
import java.util.Map;
import java.util.UUID;
import org.apache.any23.extractor.ExtractionResult;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;

class JSONLDJavaSink
implements JsonLdTripleCallback {
    private static final String BNODE_PREFIX = "_:";
    private final ExtractionResult handler;
    private final ValueFactory valueFactory;
    private final String bNodeUniquifier;

    JSONLDJavaSink(ExtractionResult handler, ValueFactory valueFactory) {
        this.handler = handler;
        this.valueFactory = valueFactory;
        this.bNodeUniquifier = "n" + UUID.randomUUID().toString().replace("-", "") + "x";
    }

    private Resource createResource(RDFDataset.Node resource) {
        String value;
        String string = value = resource == null ? null : resource.getValue();
        if (value != null && value.startsWith(BNODE_PREFIX)) {
            Object bNodeId = value.substring(BNODE_PREFIX.length());
            if (((String)bNodeId).length() < 32) {
                if (((String)bNodeId).isEmpty()) {
                    bNodeId = Integer.toHexString(System.identityHashCode(resource));
                }
                bNodeId = this.bNodeUniquifier + (String)bNodeId;
            }
            return this.valueFactory.createBNode((String)bNodeId);
        }
        return this.valueFactory.createIRI(value);
    }

    private void writeQuad(RDFDataset.Node sNode, RDFDataset.Node pNode, Value o, String graphName) {
        if (graphName != null && graphName.startsWith(BNODE_PREFIX)) {
            return;
        }
        Resource s = this.createResource(sNode);
        IRI p = this.valueFactory.createIRI(pNode == null ? null : pNode.getValue());
        if (s == null || p == null || o == null) {
            return;
        }
        if (graphName == null || graphName.isEmpty() || "@default".equalsIgnoreCase(graphName)) {
            this.handler.writeTriple(s, p, o);
        } else {
            this.handler.writeTriple(s, p, o, this.valueFactory.createIRI(graphName));
        }
    }

    public Object call(RDFDataset dataset) {
        for (Map.Entry nextNamespace : dataset.getNamespaces().entrySet()) {
            this.handler.writeNamespace((String)nextNamespace.getKey(), (String)nextNamespace.getValue());
        }
        for (String graphName : dataset.keySet()) {
            for (RDFDataset.Quad quad : dataset.getQuads(graphName)) {
                RDFDataset.Node s = quad.getSubject();
                RDFDataset.Node p = quad.getPredicate();
                RDFDataset.Node o = quad.getObject();
                if (o == null || !o.isLiteral()) {
                    this.writeQuad(s, p, (Value)this.createResource(o), graphName);
                    continue;
                }
                String lang = o.getLanguage();
                String datatype = o.getDatatype();
                String literal = o.getValue();
                if (lang != null && !lang.isEmpty() && (datatype == null || datatype.indexOf(58) < 0 || "http://www.w3.org/1999/02/22-rdf-syntax-ns#langString".equalsIgnoreCase(datatype) || "http://www.w3.org/2001/XMLSchema#string".equalsIgnoreCase(datatype))) {
                    this.writeQuad(s, p, (Value)this.valueFactory.createLiteral(literal, lang), graphName);
                    continue;
                }
                if (datatype != null && !datatype.isEmpty()) {
                    this.writeQuad(s, p, (Value)this.valueFactory.createLiteral(literal, this.valueFactory.createIRI(datatype)), graphName);
                    continue;
                }
                this.writeQuad(s, p, (Value)this.valueFactory.createLiteral(literal), graphName);
            }
        }
        return null;
    }
}

