/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.extractor.html;

import java.util.List;
import org.apache.any23.extractor.ExtractionException;
import org.apache.any23.extractor.ExtractionResult;
import org.apache.any23.extractor.ExtractorDescription;
import org.apache.any23.extractor.TagSoupExtractionResult;
import org.apache.any23.extractor.html.DomUtils;
import org.apache.any23.extractor.html.EntityBasedMicroformatExtractor;
import org.apache.any23.extractor.html.HReviewExtractorFactory;
import org.apache.any23.extractor.html.HTMLDocument;
import org.apache.any23.vocab.DCTerms;
import org.apache.any23.vocab.Review;
import org.apache.any23.vocab.VCard;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.w3c.dom.Node;

public class HReviewExtractor
extends EntityBasedMicroformatExtractor {
    private static final Review vREVIEW = Review.getInstance();
    private static final VCard vVCARD = VCard.getInstance();
    private static final DCTerms vDCTERMS = DCTerms.getInstance();

    @Override
    public ExtractorDescription getDescription() {
        return HReviewExtractorFactory.getDescriptionInstance();
    }

    @Override
    protected String getBaseClassName() {
        return "hreview";
    }

    @Override
    protected void resetExtractor() {
    }

    @Override
    protected boolean extractEntity(Node node, ExtractionResult out) throws ExtractionException {
        BNode rev = this.getBlankNodeFor(node);
        out.writeTriple((Resource)rev, RDF.TYPE, (Value)HReviewExtractor.vREVIEW.Review);
        HTMLDocument fragment = new HTMLDocument(node);
        this.addRating(fragment, (Resource)rev);
        this.addSummary(fragment, (Resource)rev);
        this.addTime(fragment, (Resource)rev);
        this.addType(fragment, (Resource)rev);
        this.addDescription(fragment, (Resource)rev);
        this.addItem(fragment, rev);
        this.addReviewer(fragment, (Resource)rev);
        TagSoupExtractionResult tser = (TagSoupExtractionResult)out;
        tser.addResourceRoot(DomUtils.getXPathListForNode(node), (Resource)rev, this.getClass());
        return true;
    }

    private void addType(HTMLDocument doc, Resource rev) {
        HTMLDocument.TextField value = doc.getSingularTextField("type");
        this.conditionallyAddStringProperty(value.source(), rev, HReviewExtractor.vREVIEW.type, value.value());
    }

    private void addReviewer(HTMLDocument doc, Resource rev) {
        List<Node> nodes = doc.findAllByClassName("reviewer");
        if (nodes.size() > 0) {
            Node node0 = nodes.get(0);
            this.addBNodeProperty(node0, rev, HReviewExtractor.vREVIEW.reviewer, this.getBlankNodeFor(node0));
        }
    }

    private void addItem(HTMLDocument root, BNode rev) throws ExtractionException {
        List<Node> nodes = root.findAllByClassName("item");
        for (Node node : nodes) {
            Resource item = this.findDummy(new HTMLDocument(node));
            this.addBNodeProperty(node, item, HReviewExtractor.vREVIEW.hasReview, rev);
        }
    }

    private Resource findDummy(HTMLDocument item) throws ExtractionException {
        HTMLDocument.TextField[] pics;
        BNode blank = this.getBlankNodeFor(item.getDocument());
        HTMLDocument.TextField val = item.getSingularTextField("fn");
        this.conditionallyAddStringProperty(val.source(), (Resource)blank, HReviewExtractor.vVCARD.fn, val.value());
        HTMLDocument.TextField url = item.getSingularUrlField("url");
        this.conditionallyAddResourceProperty((Resource)blank, HReviewExtractor.vVCARD.url, this.getHTMLDocument().resolveIRI(url.value()));
        for (HTMLDocument.TextField pic : pics = item.getPluralUrlField("photo")) {
            this.addIRIProperty((Resource)blank, HReviewExtractor.vVCARD.photo, this.getHTMLDocument().resolveIRI(pic.value()));
        }
        return blank;
    }

    private void addRating(HTMLDocument doc, Resource rev) {
        HTMLDocument.TextField value = doc.getSingularTextField("rating");
        this.conditionallyAddStringProperty(value.source(), rev, HReviewExtractor.vREVIEW.rating, value.value());
    }

    private void addSummary(HTMLDocument doc, Resource rev) {
        HTMLDocument.TextField value = doc.getSingularTextField("summary");
        this.conditionallyAddStringProperty(value.source(), rev, HReviewExtractor.vREVIEW.title, value.value());
    }

    private void addTime(HTMLDocument doc, Resource rev) {
        HTMLDocument.TextField value = doc.getSingularTextField("dtreviewed");
        this.conditionallyAddStringProperty(value.source(), rev, HReviewExtractor.vDCTERMS.date, value.value());
    }

    private void addDescription(HTMLDocument doc, Resource rev) {
        HTMLDocument.TextField value = doc.getSingularTextField("description");
        this.conditionallyAddStringProperty(value.source(), rev, HReviewExtractor.vREVIEW.text, value.value());
    }
}

