/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.extractor.html;

import java.util.List;
import org.apache.any23.extractor.ExtractionResult;
import org.apache.any23.extractor.ExtractorDescription;
import org.apache.any23.extractor.TagSoupExtractionResult;
import org.apache.any23.extractor.html.DomUtils;
import org.apache.any23.extractor.html.EntityBasedMicroformatExtractor;
import org.apache.any23.extractor.html.HResumeExtractorFactory;
import org.apache.any23.extractor.html.HTMLDocument;
import org.apache.any23.vocab.DOAC;
import org.apache.any23.vocab.FOAF;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.w3c.dom.Node;

public class HResumeExtractor
extends EntityBasedMicroformatExtractor {
    private static final FOAF vFOAF = FOAF.getInstance();
    private static final DOAC vDOAC = DOAC.getInstance();

    @Override
    public ExtractorDescription getDescription() {
        return HResumeExtractorFactory.getDescriptionInstance();
    }

    @Override
    public String getBaseClassName() {
        return "hresume";
    }

    @Override
    protected void resetExtractor() {
    }

    @Override
    protected boolean extractEntity(Node node, ExtractionResult out) {
        if (null == node) {
            return false;
        }
        BNode person = this.getBlankNodeFor(node);
        out.writeTriple((Resource)person, RDF.TYPE, (Value)HResumeExtractor.vFOAF.Person);
        HTMLDocument fragment = new HTMLDocument(node);
        this.addSummary(fragment, (Resource)person);
        this.addContact(fragment, (Resource)person);
        this.addExperiences(fragment, (Resource)person);
        this.addEducations(fragment, (Resource)person);
        this.addAffiliations(fragment, (Resource)person);
        this.addSkills(fragment, (Resource)person);
        TagSoupExtractionResult tser = (TagSoupExtractionResult)out;
        tser.addResourceRoot(DomUtils.getXPathListForNode(node), (Resource)person, this.getClass());
        return true;
    }

    private void addSummary(HTMLDocument doc, Resource person) {
        HTMLDocument.TextField summary = doc.getSingularTextField("summary");
        this.conditionallyAddStringProperty(summary.source(), person, HResumeExtractor.vDOAC.summary, summary.value());
    }

    private void addContact(HTMLDocument doc, Resource person) {
        List<Node> nodes = doc.findAllByClassName("contact");
        if (nodes.size() > 0) {
            this.addBNodeProperty(nodes.get(0), person, HResumeExtractor.vFOAF.isPrimaryTopicOf, this.getBlankNodeFor(nodes.get(0)));
        }
    }

    private void addExperiences(HTMLDocument doc, Resource person) {
        List<Node> nodes = doc.findAllByClassName("experience");
        for (Node node : nodes) {
            BNode exp = this.valueFactory.createBNode();
            if (!this.addExperience((Resource)exp, new HTMLDocument(node))) continue;
            this.addBNodeProperty(node, person, HResumeExtractor.vDOAC.experience, exp);
        }
    }

    private boolean addExperience(Resource exp, HTMLDocument document) {
        Node documentNode = document.getDocument();
        Object check = "";
        HTMLDocument.TextField value = document.getSingularTextField("title");
        check = (String)check + value;
        this.conditionallyAddStringProperty(value.source(), exp, HResumeExtractor.vDOAC.title, value.value().trim());
        value = document.getSingularTextField("dtstart");
        check = (String)check + value;
        this.conditionallyAddStringProperty(documentNode, exp, HResumeExtractor.vDOAC.start_date, value.value().trim());
        value = document.getSingularTextField("dtend");
        check = (String)check + value;
        this.conditionallyAddStringProperty(documentNode, exp, HResumeExtractor.vDOAC.end_date, value.value().trim());
        value = document.getSingularTextField("summary");
        check = (String)check + value;
        this.conditionallyAddStringProperty(documentNode, exp, HResumeExtractor.vDOAC.organization, value.value().trim());
        return !"".equals(check);
    }

    private void addEducations(HTMLDocument doc, Resource person) {
        List<Node> nodes = doc.findAllByClassName("education");
        for (Node node : nodes) {
            BNode exp = this.valueFactory.createBNode();
            if (!this.addExperience((Resource)exp, new HTMLDocument(node))) continue;
            this.addBNodeProperty(node, person, HResumeExtractor.vDOAC.education, exp);
        }
    }

    private void addAffiliations(HTMLDocument doc, Resource person) {
        List<Node> nodes = doc.findAllByClassName("affiliation");
        for (Node node : nodes) {
            this.addBNodeProperty(node, person, HResumeExtractor.vDOAC.affiliation, this.getBlankNodeFor(node));
        }
    }

    private void addSkills(HTMLDocument doc, Resource person) {
        List<Node> nodes = doc.findAllByClassName("skill");
        for (Node node : nodes) {
            this.conditionallyAddStringProperty(node, person, HResumeExtractor.vDOAC.skill, this.extractSkillValue(node));
        }
        nodes = doc.findAllByClassName("skills");
        for (Node node : nodes) {
            String[] skills;
            String nodeText = node.getTextContent();
            for (String skill : skills = nodeText.split(",")) {
                this.conditionallyAddStringProperty(node, person, HResumeExtractor.vDOAC.skill, skill.trim());
            }
        }
    }

    private String extractSkillValue(Node n) {
        String name = n.getNodeName();
        String skill = null;
        skill = "A".equals(name) && DomUtils.hasAttribute(n, "rel", "tag") ? n.getAttributes().getNamedItem("href").getTextContent() : n.getTextContent();
        return skill;
    }
}

