/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.extractor.html;

import org.apache.any23.extractor.ExtractionException;
import org.apache.any23.extractor.ExtractionResult;
import org.apache.any23.extractor.ExtractorDescription;
import org.apache.any23.extractor.html.EntityBasedMicroformatExtractor;
import org.apache.any23.extractor.html.HRecipeExtractorFactory;
import org.apache.any23.extractor.html.HTMLDocument;
import org.apache.any23.vocab.HRecipe;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.w3c.dom.Node;

public class HRecipeExtractor
extends EntityBasedMicroformatExtractor {
    private static final HRecipe vHRECIPE = HRecipe.getInstance();

    @Override
    public ExtractorDescription getDescription() {
        return HRecipeExtractorFactory.getDescriptionInstance();
    }

    @Override
    protected String getBaseClassName() {
        return "hrecipe";
    }

    @Override
    protected void resetExtractor() {
    }

    @Override
    protected boolean extractEntity(Node node, ExtractionResult out) throws ExtractionException {
        BNode recipe = this.getBlankNodeFor(node);
        this.conditionallyAddResourceProperty((Resource)recipe, RDF.TYPE, HRecipeExtractor.vHRECIPE.Recipe);
        HTMLDocument fragment = new HTMLDocument(node);
        this.addFN(fragment, recipe);
        this.addIngredients(fragment, recipe);
        this.addYield(fragment, recipe);
        this.addInstructions(fragment, recipe);
        this.addDurations(fragment, recipe);
        this.addPhoto(fragment, recipe);
        this.addSummary(fragment, recipe);
        this.addAuthors(fragment, recipe);
        this.addPublished(fragment, recipe);
        this.addNutritions(fragment, recipe);
        this.addTags(fragment, recipe);
        return true;
    }

    private void mapFieldWithProperty(HTMLDocument fragment, BNode recipe, String fieldClass, IRI property) {
        HTMLDocument.TextField title = fragment.getSingularTextField(fieldClass);
        this.conditionallyAddStringProperty(title.source(), (Resource)recipe, property, title.value());
    }

    private void addFN(HTMLDocument fragment, BNode recipe) {
        this.mapFieldWithProperty(fragment, recipe, "fn", HRecipeExtractor.vHRECIPE.fn);
    }

    private BNode addIngredient(HTMLDocument fragment, HTMLDocument.TextField ingredient) {
        BNode ingredientBnode = this.getBlankNodeFor(ingredient.source());
        this.addIRIProperty((Resource)ingredientBnode, RDF.TYPE, HRecipeExtractor.vHRECIPE.Ingredient);
        this.conditionallyAddStringProperty(ingredient.source(), (Resource)ingredientBnode, HRecipeExtractor.vHRECIPE.ingredientName, HTMLDocument.readNodeContent(ingredient.source(), true));
        this.mapFieldWithProperty(fragment, ingredientBnode, "value", HRecipeExtractor.vHRECIPE.ingredientQuantity);
        this.mapFieldWithProperty(fragment, ingredientBnode, "type", HRecipeExtractor.vHRECIPE.ingredientQuantityType);
        return ingredientBnode;
    }

    private void addIngredients(HTMLDocument fragment, BNode recipe) {
        HTMLDocument.TextField[] ingredients;
        for (HTMLDocument.TextField ingredient : ingredients = fragment.getPluralTextField("ingredient")) {
            this.addBNodeProperty((Resource)recipe, HRecipeExtractor.vHRECIPE.ingredient, this.addIngredient(fragment, ingredient));
        }
    }

    private void addInstructions(HTMLDocument fragment, BNode recipe) {
        this.mapFieldWithProperty(fragment, recipe, "instructions", HRecipeExtractor.vHRECIPE.instructions);
    }

    private void addYield(HTMLDocument fragment, BNode recipe) {
        this.mapFieldWithProperty(fragment, recipe, "yield", HRecipeExtractor.vHRECIPE.yield);
    }

    private BNode addDuration(HTMLDocument fragment, HTMLDocument.TextField duration) {
        BNode durationBnode = this.getBlankNodeFor(duration.source());
        this.addIRIProperty((Resource)durationBnode, RDF.TYPE, HRecipeExtractor.vHRECIPE.Duration);
        this.conditionallyAddStringProperty(duration.source(), (Resource)durationBnode, HRecipeExtractor.vHRECIPE.durationTime, duration.value());
        this.mapFieldWithProperty(fragment, durationBnode, "value-title", HRecipeExtractor.vHRECIPE.durationTitle);
        return durationBnode;
    }

    private void addDurations(HTMLDocument fragment, BNode recipe) {
        HTMLDocument.TextField[] durations;
        for (HTMLDocument.TextField duration : durations = fragment.getPluralTextField("duration")) {
            this.addBNodeProperty((Resource)recipe, HRecipeExtractor.vHRECIPE.duration, this.addDuration(fragment, duration));
        }
    }

    private void addPhoto(HTMLDocument fragment, BNode recipe) throws ExtractionException {
        HTMLDocument.TextField[] photos;
        for (HTMLDocument.TextField photo : photos = fragment.getPluralUrlField("photo")) {
            this.addIRIProperty((Resource)recipe, HRecipeExtractor.vHRECIPE.photo, fragment.resolveIRI(photo.value()));
        }
    }

    private void addSummary(HTMLDocument fragment, BNode recipe) {
        this.mapFieldWithProperty(fragment, recipe, "summary", HRecipeExtractor.vHRECIPE.summary);
    }

    private void addAuthors(HTMLDocument fragment, BNode recipe) {
        HTMLDocument.TextField[] authors;
        for (HTMLDocument.TextField author : authors = fragment.getPluralTextField("author")) {
            this.conditionallyAddStringProperty(author.source(), (Resource)recipe, HRecipeExtractor.vHRECIPE.author, author.value());
        }
    }

    private void addPublished(HTMLDocument fragment, BNode recipe) {
        this.mapFieldWithProperty(fragment, recipe, "published", HRecipeExtractor.vHRECIPE.published);
    }

    private BNode addNutrition(HTMLDocument fragment, HTMLDocument.TextField nutrition) {
        BNode nutritionBnode = this.getBlankNodeFor(nutrition.source());
        this.addIRIProperty((Resource)nutritionBnode, RDF.TYPE, HRecipeExtractor.vHRECIPE.Nutrition);
        this.conditionallyAddStringProperty(nutrition.source(), (Resource)nutritionBnode, HRecipeExtractor.vHRECIPE.nutritionValue, nutrition.value());
        this.mapFieldWithProperty(fragment, nutritionBnode, "value", HRecipeExtractor.vHRECIPE.nutritionValue);
        this.mapFieldWithProperty(fragment, nutritionBnode, "type", HRecipeExtractor.vHRECIPE.nutritionValueType);
        return nutritionBnode;
    }

    private void addNutritions(HTMLDocument fragment, BNode recipe) {
        HTMLDocument.TextField[] nutritions;
        for (HTMLDocument.TextField nutrition : nutritions = fragment.getPluralTextField("nutrition")) {
            this.addBNodeProperty((Resource)recipe, HRecipeExtractor.vHRECIPE.nutrition, this.addNutrition(fragment, nutrition));
        }
    }

    private void addTags(HTMLDocument fragment, BNode recipe) {
        HTMLDocument.TextField[] tags;
        for (HTMLDocument.TextField tag : tags = fragment.extractRelTagNodes()) {
            this.conditionallyAddStringProperty(tag.source(), (Resource)recipe, HRecipeExtractor.vHRECIPE.tag, tag.value());
        }
    }
}

