/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.extractor.html;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.any23.extractor.html.HTMLDocument;
import org.w3c.dom.Node;

public class HCardName {
    public static final String GIVEN_NAME = "given-name";
    public static final String FAMILY_NAME = "family-name";
    public static final String ADDITIONAL_NAME = "additional-name";
    public static final String NICKNAME = "nickname";
    public static final String HONORIFIC_PREFIX = "honorific-prefix";
    public static final String HONORIFIC_SUFFIX = "honorific-suffix";
    public static final String[] FIELDS = new String[]{"given-name", "family-name", "additional-name", "nickname", "honorific-prefix", "honorific-suffix"};
    private static final String[] NAME_COMPONENTS = new String[]{"honorific-prefix", "given-name", "additional-name", "family-name", "honorific-suffix"};
    private Map<String, FieldValue> fields = new HashMap<String, FieldValue>();
    private HTMLDocument.TextField[] fullName = null;
    private HTMLDocument.TextField organization = null;
    private HTMLDocument.TextField unit = null;

    private static HTMLDocument.TextField join(HTMLDocument.TextField[] sarray, String delimiter) {
        StringBuilder builder = new StringBuilder();
        int sarrayLengthMin2 = sarray.length - 1;
        for (int i = 0; i < sarray.length; ++i) {
            builder.append(sarray[i].value());
            if (i >= sarrayLengthMin2) continue;
            builder.append(delimiter);
        }
        return new HTMLDocument.TextField(builder.toString(), sarray[0].source());
    }

    public void reset() {
        this.fields.clear();
        this.fullName = null;
        this.organization = null;
        this.unit = null;
    }

    public void setField(String fieldName, HTMLDocument.TextField nd) {
        String value = this.fixWhiteSpace(nd.value());
        if (value == null) {
            return;
        }
        FieldValue fieldValue = this.fields.get(fieldName);
        if (fieldValue == null) {
            fieldValue = new FieldValue();
            this.fields.put(fieldName, fieldValue);
        }
        fieldValue.addValue(new HTMLDocument.TextField(value, nd.source()));
    }

    public void setFullName(HTMLDocument.TextField nd) {
        String value = this.fixWhiteSpace(nd.value());
        if (value == null) {
            return;
        }
        String[] split = value.split("\\s+");
        String split0 = split[0];
        int split0Length = split0.length();
        if (split.length > 1 && split0.charAt(split0Length - 1) == ',') {
            String swap = split[1];
            split[1] = split0.substring(0, split0Length - 1);
            split[0] = swap;
        }
        HTMLDocument.TextField[] splitFields = new HTMLDocument.TextField[split.length];
        for (int i = 0; i < split.length; ++i) {
            splitFields[i] = new HTMLDocument.TextField(split[i], nd.source());
        }
        this.fullName = splitFields;
    }

    public void setOrganization(HTMLDocument.TextField nd) {
        String value = this.fixWhiteSpace(nd.value());
        if (value == null) {
            return;
        }
        this.organization = new HTMLDocument.TextField(value, nd.source());
    }

    public boolean isMultiField(String fieldName) {
        FieldValue fieldValue = this.fields.get(fieldName);
        return fieldValue != null && fieldValue.isMultiField();
    }

    public boolean containsField(String fieldName) {
        return GIVEN_NAME.equals(fieldName) || FAMILY_NAME.equals(fieldName) || this.fields.containsKey(fieldName);
    }

    public HTMLDocument.TextField getField(String fieldName) {
        if (GIVEN_NAME.equals(fieldName)) {
            return this.getFullNamePart(GIVEN_NAME, 0);
        }
        if (FAMILY_NAME.equals(fieldName)) {
            return this.getFullNamePart(FAMILY_NAME, Integer.MAX_VALUE);
        }
        FieldValue v = this.fields.get(fieldName);
        return v == null ? null : v.getValue();
    }

    public Collection<HTMLDocument.TextField> getFields(String fieldName) {
        FieldValue v = this.fields.get(fieldName);
        return v == null ? Collections.emptyList() : v.getValues();
    }

    private HTMLDocument.TextField getFullNamePart(String fieldName, int index) {
        if (this.fields.containsKey(fieldName)) {
            return this.fields.get(fieldName).getValue();
        }
        if (this.fullName == null) {
            return null;
        }
        if (this.organization != null && this.fullName[0].value().equals(this.organization.value())) {
            return null;
        }
        if (index != Integer.MAX_VALUE && this.fullName.length <= index) {
            return null;
        }
        return this.fullName[index == Integer.MAX_VALUE ? this.fullName.length - 1 : index];
    }

    public boolean hasField(String fieldName) {
        return this.getField(fieldName) != null;
    }

    public boolean hasAnyField() {
        for (String fieldName : FIELDS) {
            if (!this.hasField(fieldName)) continue;
            return true;
        }
        return false;
    }

    public HTMLDocument.TextField getFullName() {
        if (this.fullName != null) {
            return HCardName.join(this.fullName, " ");
        }
        StringBuffer s = new StringBuffer();
        boolean empty = true;
        Node first = null;
        for (String fieldName : NAME_COMPONENTS) {
            if (!this.hasField(fieldName)) continue;
            if (!empty) {
                s.append(' ');
            }
            HTMLDocument.TextField current = this.getField(fieldName);
            if (first == null) {
                first = current.source();
            }
            s.append(current.value());
            empty = false;
        }
        if (empty) {
            return null;
        }
        return new HTMLDocument.TextField(s.toString(), first);
    }

    public HTMLDocument.TextField getOrganization() {
        return this.organization;
    }

    public void setOrganizationUnit(HTMLDocument.TextField nd) {
        String value = this.fixWhiteSpace(nd.value());
        if (value == null) {
            return;
        }
        this.unit = new HTMLDocument.TextField(value, nd.source());
    }

    public HTMLDocument.TextField getOrganizationUnit() {
        return this.unit;
    }

    private String fixWhiteSpace(String s) {
        if (s == null) {
            return null;
        }
        if ("".equals(s = s.trim().replaceAll("\\s+", " "))) {
            return null;
        }
        return s;
    }

    private static class FieldValue {
        private HTMLDocument.TextField value;
        private List<HTMLDocument.TextField> multiValue = new ArrayList<HTMLDocument.TextField>();

        FieldValue() {
        }

        void addValue(HTMLDocument.TextField v) {
            if (this.value == null && this.multiValue == null) {
                this.value = v;
            } else if (this.multiValue == null) {
                this.multiValue = new ArrayList<HTMLDocument.TextField>();
                this.multiValue.add(this.value);
                this.value = null;
                this.multiValue.add(v);
            } else {
                this.multiValue.add(v);
            }
        }

        boolean isMultiField() {
            return this.value == null;
        }

        HTMLDocument.TextField getValue() {
            return this.value != null ? this.value : this.multiValue.get(0);
        }

        Collection<HTMLDocument.TextField> getValues() {
            return this.value != null ? Arrays.asList(this.value) : this.multiValue;
        }
    }
}

