/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.extractor.html;

import org.apache.any23.extractor.ExtractionResult;
import org.apache.any23.extractor.ExtractorDescription;
import org.apache.any23.extractor.TagSoupExtractionResult;
import org.apache.any23.extractor.html.EntityBasedMicroformatExtractor;
import org.apache.any23.extractor.html.GeoExtractorFactory;
import org.apache.any23.extractor.html.HTMLDocument;
import org.apache.any23.vocab.VCard;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.w3c.dom.Node;

public class GeoExtractor
extends EntityBasedMicroformatExtractor {
    private static final VCard vVCARD = VCard.getInstance();

    @Override
    public ExtractorDescription getDescription() {
        return GeoExtractorFactory.getDescriptionInstance();
    }

    @Override
    protected String getBaseClassName() {
        return "geo";
    }

    @Override
    protected void resetExtractor() {
    }

    @Override
    protected boolean extractEntity(Node node, ExtractionResult out) {
        if (null == node) {
            return false;
        }
        HTMLDocument document = new HTMLDocument(node);
        HTMLDocument.TextField latNode = document.getSingularTextField("latitude");
        HTMLDocument.TextField lonNode = document.getSingularTextField("longitude");
        String lat = latNode.value();
        String lon = lonNode.value();
        if ("".equals(lat) || "".equals(lon)) {
            String[] both = document.getSingularUrlField("geo").value().split(";");
            if (both.length != 2) {
                return false;
            }
            lat = both[0];
            lon = both[1];
        }
        BNode geo = this.getBlankNodeFor(node);
        out.writeTriple((Resource)geo, RDF.TYPE, (Value)GeoExtractor.vVCARD.Location);
        this.conditionallyAddStringProperty(latNode.source(), (Resource)geo, GeoExtractor.vVCARD.latitude, lat);
        this.conditionallyAddStringProperty(lonNode.source(), (Resource)geo, GeoExtractor.vVCARD.longitude, lon);
        TagSoupExtractionResult tser = (TagSoupExtractionResult)this.getCurrentExtractionResult();
        tser.addResourceRoot(document.getPathToLocalRoot(), (Resource)geo, this.getClass());
        return true;
    }
}

