/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.extractor.html;

import org.apache.any23.extractor.ExtractionResult;
import org.apache.any23.extractor.ExtractorDescription;
import org.apache.any23.extractor.TagSoupExtractionResult;
import org.apache.any23.extractor.html.AdrExtractorFactory;
import org.apache.any23.extractor.html.EntityBasedMicroformatExtractor;
import org.apache.any23.extractor.html.HTMLDocument;
import org.apache.any23.vocab.VCard;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.w3c.dom.Node;

public class AdrExtractor
extends EntityBasedMicroformatExtractor {
    private static final VCard vVCARD = VCard.getInstance();
    private static final String[] addressFields = new String[]{"post-office-box", "extended-address", "street-address", "locality", "region", "country-name", "postal-code"};

    @Override
    protected String getBaseClassName() {
        return "adr";
    }

    @Override
    protected void resetExtractor() {
    }

    @Override
    protected boolean extractEntity(Node node, ExtractionResult out) {
        HTMLDocument.TextField[] types;
        if (null == node) {
            return false;
        }
        HTMLDocument document = new HTMLDocument(node);
        BNode adr = this.getBlankNodeFor(node);
        out.writeTriple((Resource)adr, RDF.TYPE, (Value)AdrExtractor.vVCARD.Address);
        String extractorName = this.getDescription().getExtractorName();
        for (String field : addressFields) {
            HTMLDocument.TextField[] values;
            for (HTMLDocument.TextField val : values = document.getPluralTextField(field)) {
                this.conditionallyAddStringProperty(val.source(), (Resource)adr, vVCARD.getProperty(field), val.value());
            }
        }
        for (HTMLDocument.TextField val : types = document.getPluralTextField("type")) {
            this.conditionallyAddStringProperty(val.source(), (Resource)adr, AdrExtractor.vVCARD.addressType, val.value());
        }
        TagSoupExtractionResult tser = (TagSoupExtractionResult)this.getCurrentExtractionResult();
        tser.addResourceRoot(document.getPathToLocalRoot(), (Resource)adr, this.getClass());
        return true;
    }

    @Override
    public ExtractorDescription getDescription() {
        return AdrExtractorFactory.getDescriptionInstance();
    }
}

