/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.extractor;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.any23.extractor.ExtractionResult;
import org.apache.any23.extractor.html.MicroformatExtractor;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.Resource;

public interface TagSoupExtractionResult
extends ExtractionResult {
    public void addResourceRoot(String[] var1, Resource var2, Class<? extends MicroformatExtractor> var3);

    public List<ResourceRoot> getResourceRoots();

    public void addPropertyPath(Class<? extends MicroformatExtractor> var1, Resource var2, Resource var3, BNode var4, String[] var5);

    public List<PropertyPath> getPropertyPaths();

    public static class PropertyPath {
        private Class<? extends MicroformatExtractor> extractor;
        private String[] path;
        private Resource subject;
        private Resource property;
        private BNode object;

        public PropertyPath(String[] path, Resource subject, Resource property, BNode object, Class<? extends MicroformatExtractor> extractor) {
            if (path == null) {
                throw new NullPointerException("path cannot be null.");
            }
            if (subject == null) {
                throw new NullPointerException("subject cannot be null.");
            }
            if (property == null) {
                throw new NullPointerException("property cannot be null.");
            }
            if (extractor == null) {
                throw new NullPointerException("extractor cannot be null.");
            }
            this.path = path;
            this.subject = subject;
            this.property = property;
            this.object = object;
            this.extractor = extractor;
        }

        public String[] getPath() {
            return this.path;
        }

        public Resource getSubject() {
            return this.subject;
        }

        public Resource getProperty() {
            return this.property;
        }

        public BNode getObject() {
            return this.object;
        }

        public Class<? extends MicroformatExtractor> getExtractor() {
            return this.extractor;
        }

        public String toString() {
            return String.format(Locale.ROOT, "%s %s - %s - %s -- %s -->", this.getClass().getCanonicalName(), Arrays.toString(this.path), this.extractor, this.subject, this.property);
        }
    }

    public static class ResourceRoot {
        private String[] path;
        private Resource root;
        private Class<? extends MicroformatExtractor> extractor;

        public ResourceRoot(String[] path, Resource root, Class<? extends MicroformatExtractor> extractor) {
            if (path == null || path.length == 0) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "Invalid xpath: '%s'.", Arrays.toString(path)));
            }
            if (root == null) {
                throw new IllegalArgumentException("Invalid root, cannot be null.");
            }
            if (extractor == null) {
                throw new IllegalArgumentException("Invalid extractor, cannot ne null");
            }
            this.path = path;
            this.root = root;
            this.extractor = extractor;
        }

        public String[] getPath() {
            return this.path;
        }

        public Resource getRoot() {
            return this.root;
        }

        public Class<? extends MicroformatExtractor> getExtractor() {
            return this.extractor;
        }

        public String toString() {
            return String.format(Locale.ROOT, "%s-%s-%s %s", this.getClass().getCanonicalName(), Arrays.toString(this.path), this.root, this.extractor);
        }
    }
}

