/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.extractor;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.any23.extractor.ExtractionContext;
import org.apache.any23.extractor.ExtractionResult;
import org.apache.any23.extractor.Extractor;
import org.apache.any23.extractor.IssueReport;
import org.apache.any23.extractor.TagSoupExtractionResult;
import org.apache.any23.extractor.html.MicroformatExtractor;
import org.apache.any23.rdf.Prefixes;
import org.apache.any23.writer.TripleHandler;
import org.apache.any23.writer.TripleHandlerException;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;

public class ExtractionResultImpl
implements TagSoupExtractionResult {
    private final ExtractionContext context;
    private final Extractor<?> extractor;
    private final TripleHandler tripleHandler;
    private final Collection<ExtractionResult> subResults = new ArrayList<ExtractionResult>();
    private final Set<Object> knownContextIDs = new HashSet<Object>();
    private boolean isClosed = false;
    private boolean isInitialized = false;
    private List<IssueReport.Issue> issues;
    private List<TagSoupExtractionResult.ResourceRoot> resourceRoots;
    private List<TagSoupExtractionResult.PropertyPath> propertyPaths;

    public ExtractionResultImpl(ExtractionContext context, Extractor<?> extractor, TripleHandler tripleHandler) {
        this(context, extractor, tripleHandler, new ArrayList<IssueReport.Issue>());
    }

    private ExtractionResultImpl(ExtractionContext context, Extractor<?> extractor, TripleHandler tripleHandler, List<IssueReport.Issue> issues) {
        if (context == null) {
            throw new NullPointerException("context cannot be null.");
        }
        if (extractor == null) {
            throw new NullPointerException("extractor cannot be null.");
        }
        if (tripleHandler == null) {
            throw new NullPointerException("triple handler cannot be null.");
        }
        this.extractor = extractor;
        this.tripleHandler = tripleHandler;
        this.context = context;
        this.issues = issues;
        this.knownContextIDs.add(context.getUniqueID());
        try {
            tripleHandler.openContext(context);
        }
        catch (TripleHandlerException e) {
            throw new RuntimeException("Error while opening context", e);
        }
    }

    public boolean hasIssues() {
        return !this.issues.isEmpty();
    }

    public int getIssuesCount() {
        return this.issues.size();
    }

    public void printReport(PrintStream ps) {
        ps.print(String.format(Locale.ROOT, "Context: %s [errors: %d] {\n", this.context, this.getIssuesCount()));
        for (IssueReport.Issue issue : this.issues) {
            ps.print(issue.toString());
            ps.print("\n");
        }
        for (ExtractionResult er : this.subResults) {
            er.printReport(ps);
        }
        ps.print("}\n");
    }

    public Collection<IssueReport.Issue> getIssues() {
        return this.issues.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(this.issues);
    }

    public ExtractionResult openSubResult(ExtractionContext context) {
        String contextID = context.getUniqueID();
        if (this.knownContextIDs.contains(contextID)) {
            throw new IllegalArgumentException("Duplicate contextID: " + contextID);
        }
        this.knownContextIDs.add(contextID);
        this.checkOpen();
        ExtractionResultImpl result = new ExtractionResultImpl(context, this.extractor, this.tripleHandler, this.issues);
        this.subResults.add(result);
        return result;
    }

    public ExtractionContext getExtractionContext() {
        return this.context;
    }

    public void writeTriple(Resource s, IRI p, Value o, IRI g) {
        if (s == null || p == null || o == null) {
            return;
        }
        if (s.stringValue() == null || p.stringValue() == null || o.stringValue() == null) {
            throw new IllegalArgumentException("The statement arguments must be not null.");
        }
        this.checkOpen();
        try {
            this.tripleHandler.receiveTriple(s, p, o, g, this.context);
        }
        catch (TripleHandlerException e) {
            throw new RuntimeException(String.format(Locale.ROOT, "Error while receiving triple %s %s %s", s, p, o), e);
        }
    }

    boolean wasTouched() {
        return this.isInitialized;
    }

    public void writeTriple(Resource s, IRI p, Value o) {
        this.writeTriple(s, p, o, null);
    }

    public void writeNamespace(String prefix, String uri) {
        this.checkOpen();
        try {
            this.tripleHandler.receiveNamespace(prefix, uri, this.context);
        }
        catch (TripleHandlerException e) {
            throw new RuntimeException(String.format(Locale.ROOT, "Error while writing namespace %s:%s", prefix, uri), e);
        }
    }

    public void notifyIssue(IssueReport.IssueLevel level, String msg, long row, long col) {
        this.issues.add(new IssueReport.Issue(level, msg, row, col));
    }

    public void close() {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        for (ExtractionResult subResult : this.subResults) {
            subResult.close();
        }
        try {
            this.tripleHandler.closeContext(this.context);
        }
        catch (TripleHandlerException e) {
            throw new RuntimeException("Error while opening context", e);
        }
    }

    private void checkOpen() {
        if (!this.isInitialized) {
            this.isInitialized = true;
            Prefixes prefixes = this.extractor.getDescription().getPrefixes();
            for (String prefix : prefixes.allPrefixes()) {
                try {
                    this.tripleHandler.receiveNamespace(prefix, prefixes.getNamespaceIRIFor(prefix), this.context);
                }
                catch (TripleHandlerException e) {
                    throw new RuntimeException(String.format(Locale.ROOT, "Error while writing namespace %s", prefix), e);
                }
            }
        }
        if (this.isClosed) {
            throw new IllegalStateException("Not open: " + this.context);
        }
    }

    @Override
    public void addResourceRoot(String[] path, Resource root, Class<? extends MicroformatExtractor> extractor) {
        if (this.resourceRoots == null) {
            this.resourceRoots = new ArrayList<TagSoupExtractionResult.ResourceRoot>();
        }
        this.resourceRoots.add(new TagSoupExtractionResult.ResourceRoot(path, root, extractor));
    }

    @Override
    public List<TagSoupExtractionResult.ResourceRoot> getResourceRoots() {
        ArrayList<TagSoupExtractionResult.ResourceRoot> allRoots = new ArrayList<TagSoupExtractionResult.ResourceRoot>();
        if (this.resourceRoots != null) {
            allRoots.addAll(this.resourceRoots);
        }
        for (ExtractionResult er : this.subResults) {
            ExtractionResultImpl eri = (ExtractionResultImpl)er;
            if (eri.resourceRoots == null) continue;
            allRoots.addAll(eri.resourceRoots);
        }
        return allRoots;
    }

    @Override
    public void addPropertyPath(Class<? extends MicroformatExtractor> extractor, Resource propertySubject, Resource property, BNode object, String[] path) {
        if (this.propertyPaths == null) {
            this.propertyPaths = new ArrayList<TagSoupExtractionResult.PropertyPath>();
        }
        this.propertyPaths.add(new TagSoupExtractionResult.PropertyPath(path, propertySubject, property, object, extractor));
    }

    @Override
    public List<TagSoupExtractionResult.PropertyPath> getPropertyPaths() {
        ArrayList<TagSoupExtractionResult.PropertyPath> allPaths = new ArrayList<TagSoupExtractionResult.PropertyPath>();
        if (this.propertyPaths != null) {
            allPaths.addAll(this.propertyPaths);
        }
        for (ExtractionResult er : this.subResults) {
            ExtractionResultImpl eri = (ExtractionResultImpl)er;
            if (eri.propertyPaths == null) continue;
            allPaths.addAll(eri.propertyPaths);
        }
        return allPaths;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.context.toString());
        sb.append('\n');
        if (this.issues != null) {
            sb.append("Errors {\n");
            for (IssueReport.Issue issue : this.issues) {
                sb.append('\t');
                sb.append(issue.toString());
                sb.append('\n');
            }
        }
        sb.append("}\n");
        return sb.toString();
    }
}

