/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.any23.extractor.Extractor;
import org.apache.any23.extractor.IssueReport;
import org.apache.any23.validator.ValidationReport;

public class ExtractionReport {
    private final List<Extractor> matchingExtractors;
    private final String encoding;
    private final String detectedMimeType;
    private final ValidationReport validationReport;
    private final Map<String, Collection<IssueReport.Issue>> extractorIssues;

    public ExtractionReport(List<Extractor> matchingExtractors, String encoding, String detectedMimeType, ValidationReport validationReport, Map<String, Collection<IssueReport.Issue>> extractorIssues) {
        if (matchingExtractors == null) {
            throw new NullPointerException("list of matching extractors cannot be null.");
        }
        if (encoding == null) {
            throw new NullPointerException("encoding cannot be null.");
        }
        if (validationReport == null) {
            throw new NullPointerException("validation report cannot be null.");
        }
        this.matchingExtractors = Collections.unmodifiableList(matchingExtractors);
        this.encoding = encoding;
        this.detectedMimeType = detectedMimeType;
        this.validationReport = validationReport;
        this.extractorIssues = Collections.unmodifiableMap(extractorIssues);
    }

    public boolean hasMatchingExtractors() {
        return this.matchingExtractors.size() > 0;
    }

    public List<Extractor> getMatchingExtractors() {
        return this.matchingExtractors;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getDetectedMimeType() {
        return this.detectedMimeType;
    }

    public ValidationReport getValidationReport() {
        return this.validationReport;
    }

    public Collection<IssueReport.Issue> getExtractorIssues(String extractorName) {
        Collection<IssueReport.Issue> errors = this.extractorIssues.get(extractorName);
        return errors == null ? Collections.emptyList() : Collections.unmodifiableCollection(errors);
    }
}

