/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.writer;

import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.rio.RDFFormat;

public class TripleFormat {
    private final String name;
    private final IRI standardIRI;
    private final List<String> mimeTypes;
    private final Charset charset;
    private final List<String> fileExtensions;
    private final Capabilities capabilities;
    RDFFormat rdfFormat;
    private static final ValueFactory vf = SimpleValueFactory.getInstance();
    private static final int WRITES_TRIPLES = 1;
    private static final int WRITES_GRAPHS = 2;
    private static final int WRITES_NAMESPACES = 4;
    public static final Capabilities NONSTANDARD = new Capabilities(0);
    public static final Capabilities TRIPLES = new Capabilities(1);
    public static final Capabilities QUADS = new Capabilities(3);
    public static final Capabilities TRIPLES_AND_NAMESPACES = TRIPLES.withNamespaces();
    public static final Capabilities QUADS_AND_NAMESPACES = QUADS.withNamespaces();

    private static IllegalArgumentException mimeTypeErr(String mt) {
        return new IllegalArgumentException(mt + " is not a valid mimetype");
    }

    private static IllegalArgumentException extensionErr(String ext) {
        return new IllegalArgumentException(ext + " is not a valid extension");
    }

    private static <E> E checkNonNull(E object, String name) {
        if (object == null) {
            throw new IllegalArgumentException(name + " must not be null");
        }
        return object;
    }

    private static void checkMimeTypes(List<String> mts) {
        if (TripleFormat.checkNonNull(mts, "mimetypes").isEmpty()) {
            throw new IllegalArgumentException("mimetypes must not be empty");
        }
        for (String mt : mts) {
            boolean slash = false;
            int len = TripleFormat.checkNonNull(mt, "mimetype").length();
            for (int i = 0; i < len; ++i) {
                char ch = mt.charAt(i);
                if (ch <= ' ' || ch >= '\u007f' || ch == '(' || ch == ')' || ch == '<' || ch == '>' || ch == '@' || ch == ',' || ch == ';' || ch == ':' || ch == '\\' || ch == '\"' || ch == '[' || ch == ']' || ch == '?' || ch == '=' || ch == '*') {
                    throw TripleFormat.mimeTypeErr(mt);
                }
                if (ch != '/') continue;
                if (slash || i == 0 || i + 1 == len) {
                    throw TripleFormat.mimeTypeErr(mt);
                }
                slash = true;
            }
            if (slash) continue;
            throw TripleFormat.mimeTypeErr(mt);
        }
    }

    private static void checkExtensions(List<String> exts) {
        for (String ext : TripleFormat.checkNonNull(exts, "extensions")) {
            int illegalDot = 0;
            int len = TripleFormat.checkNonNull(ext, "extension").length();
            for (int i = 0; i < len; ++i) {
                char ch = ext.charAt(i);
                if (ch <= ' ' || ch >= '\u007f' || ch == '<' || ch == '>' || ch == ':' || ch == '\"' || ch == '/' || ch == '\\' || ch == '|' || ch == '?' || ch == '*') {
                    throw TripleFormat.extensionErr(ext);
                }
                if (ch != '.') continue;
                int next = i + 1;
                if (i == illegalDot || next == len) {
                    throw TripleFormat.extensionErr(ext);
                }
                illegalDot = next;
            }
        }
    }

    private static String normalizeMimeType(String mt) {
        return mt.toLowerCase(Locale.ENGLISH);
    }

    private static String normalizeExtension(String ext) {
        return ext.toLowerCase(Locale.ENGLISH);
    }

    private TripleFormat(String name, Collection<String> mimeTypes, Charset charset, Collection<String> fileExtensions, String standardIRI, Capabilities capabilities) {
        this.name = TripleFormat.checkNonNull(name, "display name");
        this.mimeTypes = Collections.unmodifiableList(mimeTypes.stream().map(TripleFormat::normalizeMimeType).distinct().collect(Collectors.toList()));
        TripleFormat.checkMimeTypes(this.mimeTypes);
        this.charset = charset;
        if (this.charset != null && !charset.canEncode()) {
            throw new IllegalArgumentException(charset + " does not allow encoding");
        }
        this.fileExtensions = Collections.unmodifiableList(fileExtensions.stream().map(TripleFormat::normalizeExtension).distinct().collect(Collectors.toList()));
        TripleFormat.checkExtensions(this.fileExtensions);
        this.standardIRI = standardIRI == null ? null : vf.createIRI(standardIRI);
        this.capabilities = TripleFormat.checkNonNull(capabilities, "capabilities");
    }

    public static TripleFormat of(String displayName, Collection<String> mimeTypes, Charset defaultCharset, Collection<String> fileExtensions, String standardIRI, Capabilities capabilities) {
        return new TripleFormat(displayName, mimeTypes, defaultCharset, fileExtensions, standardIRI, capabilities);
    }

    public Optional<Charset> getCharset() {
        return Optional.ofNullable(this.charset);
    }

    static Capabilities capabilities(RDFFormat format) {
        if (format.supportsContexts()) {
            return format.supportsNamespaces() ? QUADS_AND_NAMESPACES : QUADS;
        }
        return format.supportsNamespaces() ? TRIPLES_AND_NAMESPACES : TRIPLES;
    }

    private static String iri(IRI iri) {
        return iri == null ? null : iri.stringValue();
    }

    static TripleFormat of(RDFFormat format) {
        TripleFormat f = TripleFormat.of(format.getName(), format.getMIMETypes(), format.getCharset(), format.getFileExtensions(), TripleFormat.iri(format.getStandardURI()), TripleFormat.capabilities(format));
        f.rdfFormat = format;
        return f;
    }

    RDFFormat toRDFFormat() {
        RDFFormat fmt = this.rdfFormat;
        if (fmt != null) {
            return fmt;
        }
        Capabilities capabilities = this.capabilities;
        if (!capabilities.has(TRIPLES)) {
            throw new UnsupportedOperationException("This format does not print RDF triples");
        }
        this.rdfFormat = new RDFFormat(this.name, this.mimeTypes, this.charset, this.fileExtensions, this.standardIRI, capabilities.has(TRIPLES_AND_NAMESPACES), capabilities.has(QUADS), false);
        return this.rdfFormat;
    }

    public Optional<IRI> getStandardIRI() {
        return Optional.ofNullable(this.standardIRI);
    }

    public List<String> getMimeTypes() {
        return this.mimeTypes;
    }

    public String getMimeType() {
        return this.mimeTypes.get(0);
    }

    public List<String> getExtensions() {
        return this.fileExtensions;
    }

    public Optional<String> getExtension() {
        return this.fileExtensions.isEmpty() ? Optional.empty() : Optional.of(this.fileExtensions.get(0));
    }

    public Capabilities getCapabilities() {
        return this.capabilities;
    }

    public String getDisplayName() {
        return this.name;
    }

    public String toString() {
        return this.name + this.mimeTypes.stream().collect(Collectors.joining(", ", " (mimeTypes=", "; ")) + this.fileExtensions.stream().collect(Collectors.joining(", ", "ext=", ")"));
    }

    public static class Capabilities {
        private final int raw;

        private Capabilities(int raw) {
            this.raw = raw;
        }

        public boolean has(Capabilities other) {
            int oraw = other.raw;
            return (this.raw & oraw) == oraw;
        }

        private Capabilities withNamespaces() {
            return new Capabilities(this.raw | 4);
        }
    }
}

