/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.source;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.any23.http.HTTPClient;
import org.apache.any23.source.DocumentSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPDocumentSource
implements DocumentSource {
    private static final Logger LOG = LoggerFactory.getLogger(HTTPDocumentSource.class);
    private final HTTPClient client;
    private String uri;
    private InputStream unusedInputStream = null;
    private boolean loaded = false;

    public HTTPDocumentSource(HTTPClient client, String uri) throws URISyntaxException {
        this.client = client;
        this.uri = this.normalize(uri);
    }

    private String normalize(String uri) throws URISyntaxException {
        try {
            URI normalized = new URI(uri).normalize();
            return normalized.toString();
        }
        catch (URISyntaxException e) {
            LOG.warn("Invalid uri: {}", (Object)uri);
            LOG.error("Can not convert URL", (Throwable)e);
            throw e;
        }
    }

    private void ensureOpen() throws IOException {
        if (this.loaded) {
            return;
        }
        this.loaded = true;
        this.unusedInputStream = this.client.openInputStream(this.uri);
        if (this.client.getActualDocumentIRI() != null) {
            this.uri = this.client.getActualDocumentIRI();
        }
    }

    public InputStream openInputStream() throws IOException {
        this.ensureOpen();
        if (this.unusedInputStream != null) {
            InputStream temp = this.unusedInputStream;
            this.unusedInputStream = null;
            return temp;
        }
        return this.client.openInputStream(this.uri);
    }

    public long getContentLength() {
        return this.client.getContentLength();
    }

    public String getDocumentIRI() {
        return this.uri;
    }

    public String getContentType() {
        return this.client.getContentType();
    }

    public boolean isLocal() {
        return false;
    }
}

