/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.extractor.xpath;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.any23.extractor.ExtractionContext;
import org.apache.any23.extractor.ExtractionException;
import org.apache.any23.extractor.ExtractionParameters;
import org.apache.any23.extractor.ExtractionResult;
import org.apache.any23.extractor.Extractor;
import org.apache.any23.extractor.ExtractorDescription;
import org.apache.any23.extractor.xpath.XPathExtractionRule;
import org.apache.any23.extractor.xpath.XPathExtractorFactory;
import org.eclipse.rdf4j.model.IRI;
import org.w3c.dom.Document;

public class XPathExtractor
implements Extractor.TagSoupDOMExtractor {
    private final List<XPathExtractionRule> xPathExtractionRules = new ArrayList<XPathExtractionRule>();

    public XPathExtractor() {
    }

    public XPathExtractor(List<XPathExtractionRule> rules) {
        this.xPathExtractionRules.addAll(rules);
    }

    public void add(XPathExtractionRule rule) {
        this.xPathExtractionRules.add(rule);
    }

    public void remove(XPathExtractionRule rule) {
        this.xPathExtractionRules.remove(rule);
    }

    public boolean contains(XPathExtractionRule rule) {
        return this.xPathExtractionRules.contains(rule);
    }

    public void run(ExtractionParameters extractionParameters, ExtractionContext extractionContext, Document in, ExtractionResult out) throws IOException, ExtractionException {
        IRI documentIRI = extractionContext.getDocumentIRI();
        for (XPathExtractionRule rule : this.xPathExtractionRules) {
            if (!rule.acceptIRI(documentIRI)) continue;
            rule.process(in, out);
        }
    }

    public ExtractorDescription getDescription() {
        return XPathExtractorFactory.getDescriptionInstance();
    }
}

