/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.extractor.html.microformats2;

import java.util.List;
import org.apache.any23.extractor.ExtractionException;
import org.apache.any23.extractor.ExtractionResult;
import org.apache.any23.extractor.ExtractorDescription;
import org.apache.any23.extractor.html.EntityBasedMicroformatExtractor;
import org.apache.any23.extractor.html.HTMLDocument;
import org.apache.any23.extractor.html.microformats2.HCardExtractor;
import org.apache.any23.extractor.html.microformats2.HCardExtractorFactory;
import org.apache.any23.extractor.html.microformats2.HEventExtractorFactory;
import org.apache.any23.vocab.HEvent;
import org.apache.any23.vocab.VCard;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.w3c.dom.Node;

public class HEventExtractor
extends EntityBasedMicroformatExtractor {
    private static final HEvent vEvent = HEvent.getInstance();
    private static final VCard vVCARD = VCard.getInstance();
    private String[] eventFields = new String[]{"name", "summary", "start", "end", "duration", "description", "url", "category", "location", "attendee"};
    private static final String[] geoFields = new String[]{"latitude", "longitude", "altitude"};

    @Override
    public ExtractorDescription getDescription() {
        return HEventExtractorFactory.getDescriptionInstance();
    }

    @Override
    protected String getBaseClassName() {
        return "h-event";
    }

    @Override
    protected void resetExtractor() {
    }

    @Override
    protected boolean extractEntity(Node node, ExtractionResult out) throws ExtractionException {
        BNode event = this.getBlankNodeFor(node);
        this.conditionallyAddResourceProperty((Resource)event, RDF.TYPE, HEventExtractor.vEvent.event);
        HTMLDocument fragment = new HTMLDocument(node);
        this.addName(fragment, event);
        this.addSummary(fragment, event);
        this.addStart(fragment, event);
        this.addEnd(fragment, event);
        this.addDuration(fragment, event);
        this.addDescription(fragment, event);
        this.addURLs(fragment, event);
        this.addCategories(fragment, event);
        this.addLocations(fragment, (Resource)event);
        this.addAttendees(fragment, (Resource)event);
        return true;
    }

    public Resource extractEntityAsEmbeddedProperty(HTMLDocument fragment, BNode event, ExtractionResult out) throws ExtractionException {
        this.setCurrentExtractionResult(out);
        this.addName(fragment, event);
        this.addSummary(fragment, event);
        this.addStart(fragment, event);
        this.addEnd(fragment, event);
        this.addDuration(fragment, event);
        this.addDescription(fragment, event);
        this.addURLs(fragment, event);
        this.addCategories(fragment, event);
        this.addLocations(fragment, (Resource)event);
        this.addAttendees(fragment, (Resource)event);
        return event;
    }

    private void addAttendees(HTMLDocument doc, Resource entry) throws ExtractionException {
        List<Node> nodes = doc.findAllByClassName("p-" + this.eventFields[9] + " h-card");
        if (nodes.isEmpty()) {
            return;
        }
        HCardExtractorFactory factory = new HCardExtractorFactory();
        HCardExtractor extractor = factory.createExtractor();
        for (Node node : nodes) {
            BNode attendee = this.valueFactory.createBNode();
            this.addIRIProperty((Resource)attendee, RDF.TYPE, HEventExtractor.vEvent.attendee);
            extractor.extractEntityAsEmbeddedProperty(new HTMLDocument(node), attendee, this.getCurrentExtractionResult());
        }
    }

    private void mapFieldWithProperty(HTMLDocument fragment, BNode recipe, String fieldClass, IRI property) {
        HTMLDocument.TextField title = fragment.getSingularTextField(fieldClass);
        this.conditionallyAddStringProperty(title.source(), (Resource)recipe, property, title.value());
    }

    private void addName(HTMLDocument fragment, BNode event) {
        this.mapFieldWithProperty(fragment, event, "p-" + this.eventFields[0], HEventExtractor.vEvent.name);
    }

    private void addSummary(HTMLDocument fragment, BNode event) {
        this.mapFieldWithProperty(fragment, event, "p-" + this.eventFields[1], HEventExtractor.vEvent.summary);
    }

    private void addStart(HTMLDocument fragment, BNode event) {
        HTMLDocument.TextField start = fragment.getSingularTextField("dt-" + this.eventFields[2]);
        if (start.source() == null) {
            return;
        }
        Node attribute = start.source().getAttributes().getNamedItem("datetime");
        if (attribute == null) {
            this.conditionallyAddStringProperty(start.source(), (Resource)event, HEventExtractor.vEvent.start, start.value());
        } else {
            this.conditionallyAddStringProperty(start.source(), (Resource)event, HEventExtractor.vEvent.start, attribute.getNodeValue());
        }
    }

    private void addEnd(HTMLDocument fragment, BNode event) {
        HTMLDocument.TextField end = fragment.getSingularTextField("dt-" + this.eventFields[3]);
        if (end.source() == null) {
            return;
        }
        Node attribute = end.source().getAttributes().getNamedItem("datetime");
        if (attribute == null) {
            this.conditionallyAddStringProperty(end.source(), (Resource)event, HEventExtractor.vEvent.end, end.value());
        } else {
            this.conditionallyAddStringProperty(end.source(), (Resource)event, HEventExtractor.vEvent.end, attribute.getNodeValue());
        }
    }

    private void addDuration(HTMLDocument fragment, BNode event) {
        HTMLDocument.TextField duration = fragment.getSingularTextField("dt-" + this.eventFields[4]);
        if (duration.source() == null) {
            return;
        }
        Node attribute = duration.source().getAttributes().getNamedItem("datetime");
        if (attribute == null) {
            this.conditionallyAddStringProperty(duration.source(), (Resource)event, HEventExtractor.vEvent.duration, duration.value());
        } else {
            this.conditionallyAddStringProperty(duration.source(), (Resource)event, HEventExtractor.vEvent.duration, attribute.getNodeValue());
        }
    }

    private void addDescription(HTMLDocument fragment, BNode event) {
        this.mapFieldWithProperty(fragment, event, "p-" + this.eventFields[5], HEventExtractor.vEvent.description);
    }

    private void addURLs(HTMLDocument fragment, BNode event) throws ExtractionException {
        HTMLDocument.TextField[] urls;
        for (HTMLDocument.TextField url : urls = fragment.getPluralUrlField("u-" + this.eventFields[6])) {
            this.addIRIProperty((Resource)event, HEventExtractor.vEvent.url, fragment.resolveIRI(url.value()));
        }
    }

    private void addCategories(HTMLDocument fragment, BNode event) {
        HTMLDocument.TextField[] categories;
        for (HTMLDocument.TextField category : categories = fragment.getPluralTextField("p-" + this.eventFields[7])) {
            this.conditionallyAddStringProperty(category.source(), (Resource)event, HEventExtractor.vEvent.category, category.value());
        }
    }

    private void addLocations(HTMLDocument doc, Resource entry) throws ExtractionException {
        List<Node> nodes = doc.findAllByClassName("p-" + this.eventFields[8] + " h-geo");
        if (nodes.isEmpty()) {
            return;
        }
        for (Node node : nodes) {
            BNode location = this.valueFactory.createBNode();
            this.addIRIProperty((Resource)location, RDF.TYPE, HEventExtractor.vEvent.location);
            HTMLDocument fragment = new HTMLDocument(node);
            for (String field : geoFields) {
                HTMLDocument.TextField[] values;
                for (HTMLDocument.TextField val : values = fragment.getPluralTextField("p-" + field)) {
                    Node attribute = val.source().getAttributes().getNamedItem("title");
                    if (attribute == null) {
                        this.conditionallyAddStringProperty(val.source(), (Resource)location, vVCARD.getProperty(field), val.value());
                        continue;
                    }
                    this.conditionallyAddStringProperty(val.source(), (Resource)location, vVCARD.getProperty(field), attribute.getNodeValue());
                }
            }
        }
    }
}

