/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.extractor.html;

import java.io.IOException;
import java.util.Locale;
import org.apache.any23.extractor.ExtractionContext;
import org.apache.any23.extractor.ExtractionException;
import org.apache.any23.extractor.ExtractionParameters;
import org.apache.any23.extractor.ExtractionResult;
import org.apache.any23.extractor.Extractor;
import org.apache.any23.extractor.ExtractorDescription;
import org.apache.any23.extractor.IssueReport;
import org.apache.any23.extractor.html.HTMLDocument;
import org.apache.any23.extractor.html.XFNExtractorFactory;
import org.apache.any23.rdf.Any23ValueFactoryWrapper;
import org.apache.any23.vocab.FOAF;
import org.apache.any23.vocab.XFN;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XFNExtractor
implements Extractor.TagSoupDOMExtractor {
    private static final FOAF vFOAF = FOAF.getInstance();
    private static final XFN vXFN = XFN.getInstance();
    private static final Any23ValueFactoryWrapper factoryWrapper = new Any23ValueFactoryWrapper((ValueFactory)SimpleValueFactory.getInstance());
    private HTMLDocument document;
    private ExtractionResult out;

    public ExtractorDescription getDescription() {
        return XFNExtractorFactory.getDescriptionInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(ExtractionParameters extractionParameters, ExtractionContext extractionContext, Document in, ExtractionResult out) throws IOException, ExtractionException {
        factoryWrapper.setIssueReport((IssueReport)out);
        try {
            this.document = new HTMLDocument(in);
            this.out = out;
            BNode subject = factoryWrapper.createBNode();
            boolean foundAnyXFN = false;
            IRI documentIRI = extractionContext.getDocumentIRI();
            for (Node link : this.document.findAll("//A[@rel][@href]")) {
                foundAnyXFN |= this.extractLink(link, subject, documentIRI);
            }
            if (!foundAnyXFN) {
                return;
            }
            out.writeTriple((Resource)subject, RDF.TYPE, (Value)XFNExtractor.vFOAF.Person);
            out.writeTriple((Resource)subject, XFNExtractor.vXFN.mePage, (Value)documentIRI);
        }
        finally {
            factoryWrapper.setIssueReport(null);
        }
    }

    private boolean extractLink(Node firstLink, BNode subject, IRI documentIRI) throws ExtractionException {
        Node hrefNodeItem = firstLink.getAttributes().getNamedItem("href");
        Node relNodeItem = firstLink.getAttributes().getNamedItem("rel");
        if (hrefNodeItem == null || relNodeItem == null) {
            return false;
        }
        String href = hrefNodeItem.getNodeValue();
        String rel = relNodeItem.getNodeValue();
        String[] rels = rel.split("\\s+");
        IRI link = this.document.resolveIRI(href);
        if (this.containsRelMe(rels)) {
            if (this.containsXFNRelExceptMe(rels)) {
                return false;
            }
            this.out.writeTriple((Resource)subject, XFNExtractor.vXFN.mePage, (Value)link);
            this.out.writeTriple((Resource)documentIRI, vXFN.getExtendedProperty("me"), (Value)link);
        } else {
            BNode person2 = factoryWrapper.createBNode();
            boolean foundAnyXFNRel = false;
            for (String aRel : rels) {
                foundAnyXFNRel |= this.extractRel(aRel, subject, documentIRI, person2, link);
            }
            if (!foundAnyXFNRel) {
                return false;
            }
            this.out.writeTriple((Resource)person2, RDF.TYPE, (Value)XFNExtractor.vFOAF.Person);
            this.out.writeTriple((Resource)person2, XFNExtractor.vXFN.mePage, (Value)link);
        }
        return true;
    }

    private boolean containsRelMe(String[] rels) {
        for (String rel : rels) {
            if (!"me".equals(rel.toLowerCase(Locale.ROOT))) continue;
            return true;
        }
        return false;
    }

    private boolean containsXFNRelExceptMe(String[] rels) {
        for (String rel : rels) {
            if ("me".equals(rel.toLowerCase(Locale.ROOT)) || !vXFN.isXFNLocalName(rel)) continue;
            return true;
        }
        return false;
    }

    private boolean extractRel(String rel, BNode person1, IRI uri1, BNode person2, IRI uri2) {
        IRI peopleProp = vXFN.getPropertyByLocalName(rel);
        IRI hyperlinkProp = vXFN.getExtendedProperty(rel);
        if (peopleProp == null) {
            return false;
        }
        this.out.writeTriple((Resource)person1, peopleProp, (Value)person2);
        this.out.writeTriple((Resource)uri1, hyperlinkProp, (Value)uri2);
        return true;
    }
}

