/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.extractor.html;

import java.io.IOException;
import org.apache.any23.extractor.ExtractionContext;
import org.apache.any23.extractor.ExtractionException;
import org.apache.any23.extractor.ExtractionParameters;
import org.apache.any23.extractor.ExtractionResult;
import org.apache.any23.extractor.Extractor;
import org.apache.any23.extractor.ExtractorDescription;
import org.apache.any23.extractor.IssueReport;
import org.apache.any23.extractor.html.DomUtils;
import org.apache.any23.extractor.html.ICBMExtractorFactory;
import org.apache.any23.rdf.Any23ValueFactoryWrapper;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.w3c.dom.Document;

public class ICBMExtractor
implements Extractor.TagSoupDOMExtractor {
    public void run(ExtractionParameters extractionParameters, ExtractionContext extractionContext, Document in, ExtractionResult out) throws IOException, ExtractionException {
        float lon;
        float lat;
        String props = DomUtils.find(in, "//META[@name=\"ICBM\" or @name=\"geo.position\"]/@content");
        if ("".equals(props)) {
            return;
        }
        String[] coords = props.split("[;,]");
        try {
            lat = Float.parseFloat(coords[0]);
            lon = Float.parseFloat(coords[1]);
        }
        catch (NumberFormatException nfe) {
            return;
        }
        Any23ValueFactoryWrapper factory = new Any23ValueFactoryWrapper((ValueFactory)SimpleValueFactory.getInstance(), (IssueReport)out);
        BNode point = factory.createBNode();
        out.writeTriple((Resource)extractionContext.getDocumentIRI(), this.expand("dcterms:related"), (Value)point);
        out.writeTriple((Resource)point, this.expand("rdf:type"), (Value)this.expand("geo:Point"));
        out.writeTriple((Resource)point, this.expand("geo:lat"), (Value)factory.createLiteral(Float.toString(lat)));
        out.writeTriple((Resource)point, this.expand("geo:long"), (Value)factory.createLiteral(Float.toString(lon)));
    }

    private IRI expand(String curie) {
        return this.getDescription().getPrefixes().expand(curie);
    }

    public ExtractorDescription getDescription() {
        return ICBMExtractorFactory.getDescriptionInstance();
    }
}

