/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.extractor.csv;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.any23.extractor.ExtractionContext;
import org.apache.any23.extractor.ExtractionException;
import org.apache.any23.extractor.ExtractionParameters;
import org.apache.any23.extractor.ExtractionResult;
import org.apache.any23.extractor.Extractor;
import org.apache.any23.extractor.ExtractorDescription;
import org.apache.any23.extractor.csv.CSVExtractorFactory;
import org.apache.any23.extractor.csv.CSVReaderBuilder;
import org.apache.any23.rdf.RDFUtils;
import org.apache.any23.vocab.CSV;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.eclipse.rdf4j.model.vocabulary.XSD;

public class CSVExtractor
implements Extractor.ContentExtractor {
    private CSVParser csvParser;
    private IRI[] headerIRIs;
    private CSV csv = CSV.getInstance();

    public void setStopAtFirstError(boolean f) {
    }

    public void run(ExtractionParameters extractionParameters, ExtractionContext extractionContext, InputStream in, ExtractionResult out) throws IOException, ExtractionException {
        IRI documentIRI = extractionContext.getDocumentIRI();
        this.csvParser = CSVReaderBuilder.build((InputStream)in);
        Iterator rows = this.csvParser.iterator();
        CSVRecord header = rows.hasNext() ? (CSVRecord)rows.next() : null;
        this.headerIRIs = this.processHeader(header, documentIRI);
        this.writeHeaderPropertiesMetadata(header, out);
        int index = 0;
        while (rows.hasNext()) {
            CSVRecord nextLine = (CSVRecord)rows.next();
            IRI rowSubject = RDFUtils.iri(documentIRI.stringValue(), "row/" + index);
            out.writeTriple((Resource)rowSubject, RDF.TYPE, (Value)this.csv.rowType);
            this.produceRowStatements(rowSubject, nextLine, out);
            out.writeTriple((Resource)documentIRI, this.csv.row, (Value)rowSubject);
            out.writeTriple((Resource)rowSubject, this.csv.rowPosition, (Value)SimpleValueFactory.getInstance().createLiteral(String.valueOf(index)));
            ++index;
        }
        this.addTableMetadataStatements(documentIRI, out, index, this.headerIRIs.length);
    }

    private boolean isInteger(String number) {
        try {
            Integer.valueOf(number);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean isFloat(String number) {
        try {
            Float.valueOf(number);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private void writeHeaderPropertiesMetadata(CSVRecord header, ExtractionResult out) {
        int index = 0;
        for (IRI singleHeader : this.headerIRIs) {
            if (index > this.headerIRIs.length) break;
            String headerString = header.get(index);
            if (!RDFUtils.isAbsoluteIRI(headerString)) {
                out.writeTriple((Resource)singleHeader, RDFS.LABEL, (Value)SimpleValueFactory.getInstance().createLiteral(headerString));
            }
            out.writeTriple((Resource)singleHeader, this.csv.columnPosition, (Value)SimpleValueFactory.getInstance().createLiteral(String.valueOf(index), XSD.INTEGER));
            ++index;
        }
    }

    private IRI[] processHeader(CSVRecord header, IRI documentIRI) {
        if (header == null) {
            return new IRI[0];
        }
        IRI[] result = new IRI[header.size()];
        int index = 0;
        for (String h : header) {
            String candidate = h.trim();
            result[index] = RDFUtils.isAbsoluteIRI(candidate) ? SimpleValueFactory.getInstance().createIRI(candidate) : this.normalize(candidate, documentIRI);
            ++index;
        }
        return result;
    }

    private IRI normalize(String toBeNormalized, IRI documentIRI) {
        String newToBeNormalized = toBeNormalized.trim().toLowerCase(Locale.ROOT).replace("?", "").replace("&", "");
        StringBuilder result = new StringBuilder(documentIRI.toString());
        StringTokenizer tokenizer = new StringTokenizer(newToBeNormalized, " ");
        while (tokenizer.hasMoreTokens()) {
            String current = tokenizer.nextToken();
            result.append(Character.toUpperCase(current.charAt(0))).append(current.substring(1));
        }
        return SimpleValueFactory.getInstance().createIRI(result.toString());
    }

    private void produceRowStatements(IRI rowSubject, CSVRecord values, ExtractionResult out) {
        int index = 0;
        for (String cell : values) {
            if (index >= this.headerIRIs.length) break;
            if ("".equals(cell)) {
                ++index;
                continue;
            }
            IRI predicate = this.headerIRIs[index];
            Value object = this.getObjectFromCell(cell);
            out.writeTriple((Resource)rowSubject, predicate, object);
            ++index;
        }
    }

    private Value getObjectFromCell(String cell) {
        IRI object;
        String newCell = cell.trim();
        if (RDFUtils.isAbsoluteIRI(newCell)) {
            object = SimpleValueFactory.getInstance().createIRI(newCell);
        } else {
            IRI datatype = XSD.STRING;
            if (this.isInteger(newCell)) {
                datatype = XSD.INTEGER;
            } else if (this.isFloat(newCell)) {
                datatype = XSD.FLOAT;
            }
            object = SimpleValueFactory.getInstance().createLiteral(newCell, datatype);
        }
        return object;
    }

    private void addTableMetadataStatements(IRI documentIRI, ExtractionResult out, int numberOfRows, int numberOfColumns) {
        out.writeTriple((Resource)documentIRI, this.csv.numberOfRows, (Value)SimpleValueFactory.getInstance().createLiteral(String.valueOf(numberOfRows), XSD.INTEGER));
        out.writeTriple((Resource)documentIRI, this.csv.numberOfColumns, (Value)SimpleValueFactory.getInstance().createLiteral(String.valueOf(numberOfColumns), XSD.INTEGER));
    }

    public ExtractorDescription getDescription() {
        return CSVExtractorFactory.getDescriptionInstance();
    }
}

