/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.extractor;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.any23.extractor.Extractor;
import org.apache.any23.extractor.ExtractorFactory;
import org.apache.any23.mime.MIMEType;
import org.apache.any23.rdf.Prefixes;

public abstract class SimpleExtractorFactory<T extends Extractor<?>>
implements ExtractorFactory<T> {
    private final String name;
    private final Prefixes prefixes;
    private Collection<MIMEType> supportedMIMETypes = new ArrayList<MIMEType>();
    private String exampleInput;

    protected SimpleExtractorFactory(String name, Prefixes prefixes) {
        this.name = name;
        this.prefixes = prefixes;
    }

    protected SimpleExtractorFactory(String name, Prefixes prefixes, Collection<String> supportedMIMETypes, String exampleInput) {
        this.name = name;
        this.prefixes = prefixes == null ? Prefixes.EMPTY : prefixes;
        for (String type : supportedMIMETypes) {
            this.supportedMIMETypes.add(MIMEType.parse((String)type));
        }
        this.exampleInput = exampleInput;
    }

    public String getExtractorName() {
        return this.name;
    }

    public String getExtractorLabel() {
        return this.getClass().getName();
    }

    public Prefixes getPrefixes() {
        return this.prefixes;
    }

    public Collection<MIMEType> getSupportedMIMETypes() {
        return this.supportedMIMETypes;
    }

    public String getExampleInput() {
        return this.exampleInput;
    }
}

