/*
 * Decompiled with CFR 0.152.
 */
package org.semarglproject.rdf.rdfa;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.semarglproject.rdf.ParseException;
import org.semarglproject.rdf.RdfXmlParser;
import org.semarglproject.rdf.rdfa.RdfaParser;
import org.semarglproject.ri.RIUtils;
import org.semarglproject.sink.DataSink;
import org.semarglproject.sink.TripleSink;
import org.semarglproject.source.StreamProcessor;

final class Vocabulary {
    private final String url;
    private Map<String, Collection<String>> expansions = null;
    private Collection<String> terms = null;

    Vocabulary(String url) {
        this.url = url;
    }

    private void addExpansion(String pred, String expansion) {
        if (!this.expansions.containsKey(pred)) {
            this.expansions.put(pred, new HashSet());
        }
        this.expansions.get(pred).add(expansion);
    }

    void load() {
        URL vocabUrl;
        VocabParser vocabParser = new VocabParser();
        try {
            vocabUrl = new URL(this.url);
        }
        catch (MalformedURLException e) {
            return;
        }
        if (this.expansions == null) {
            this.expansions = new HashMap<String, Collection<String>>();
            this.terms = new HashSet<String>();
        }
        StreamProcessor rdfaSp = new StreamProcessor((DataSink)RdfaParser.connect(vocabParser));
        rdfaSp.setProperty("http://semarglproject.org/rdfa/properties/enable-vocab-expansion", (Object)false);
        this.parseVocabWithDp(vocabUrl, rdfaSp);
        if (!this.terms.isEmpty() || !this.expansions.isEmpty()) {
            return;
        }
        StreamProcessor rdfXmlSp = new StreamProcessor((DataSink)RdfXmlParser.connect((TripleSink)vocabParser));
        rdfaSp.setProperty("http://semarglproject.org/rdfa/properties/enable-vocab-expansion", (Object)false);
        this.parseVocabWithDp(vocabUrl, rdfXmlSp);
        if (this.terms.isEmpty() && this.expansions.isEmpty()) {
            this.terms = null;
            this.expansions = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseVocabWithDp(URL vocabUrl, StreamProcessor streamProcessor) {
        InputStream inputStream;
        try {
            inputStream = vocabUrl.openStream();
        }
        catch (IOException e) {
            return;
        }
        InputStreamReader reader = new InputStreamReader(inputStream);
        try {
            streamProcessor.process((Reader)reader, this.url);
        }
        catch (ParseException parseException) {
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
    }

    Collection<String> expand(String uri) {
        if (this.expansions == null || !this.expansions.containsKey(uri)) {
            return Collections.EMPTY_LIST;
        }
        return this.expansions.get(uri);
    }

    String resolveTerm(String term) {
        String termUri = this.url + term;
        if (this.terms == null && RIUtils.isAbsoluteIri((String)termUri) || this.terms != null && this.terms.contains(termUri)) {
            return termUri;
        }
        return null;
    }

    private final class VocabParser
    implements TripleSink {
        private VocabParser() {
        }

        public void addNonLiteral(String subj, String pred, String obj) {
            if (subj.startsWith("_:") || obj.startsWith("_:")) {
                return;
            }
            if (pred.equals("http://www.w3.org/2002/07/owl#equivalentProperty") || pred.equals("http://www.w3.org/2002/07/owl#equivalentClass")) {
                Vocabulary.this.addExpansion(subj, obj);
                Vocabulary.this.addExpansion(obj, subj);
                Vocabulary.this.terms.add(obj);
                Vocabulary.this.terms.add(subj);
            } else if (pred.equals("http://www.w3.org/2000/01/rdf-schema#subClassOf") || pred.equals("http://www.w3.org/2000/01/rdf-schema#subPropertyOf")) {
                Vocabulary.this.addExpansion(subj, obj);
                Vocabulary.this.terms.add(obj);
                Vocabulary.this.terms.add(subj);
            }
            if (pred.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#type") && (obj.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#Property") || obj.equals("http://www.w3.org/2000/01/rdf-schema#Class"))) {
                Vocabulary.this.terms.add(subj);
            }
        }

        public void addPlainLiteral(String subj, String pred, String content, String lang) {
        }

        public void addTypedLiteral(String subj, String pred, String content, String type) {
        }

        public void setBaseUri(String baseUri) {
        }

        public void startStream() throws ParseException {
        }

        public void endStream() throws ParseException {
        }

        public boolean setProperty(String key, Object value) {
            return false;
        }
    }
}

