/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.xml;

import biweekly.ICalDataType;
import biweekly.ICalVersion;
import biweekly.io.StreamWriter;
import java.util.HashMap;
import java.util.Map;

abstract class XCalWriterBase
extends StreamWriter {
    protected final ICalVersion targetVersion = ICalVersion.V2_0;
    protected final Map<String, ICalDataType> parameterDataTypes = new HashMap<String, ICalDataType>();

    XCalWriterBase() {
        this.registerParameterDataType("ALTREP", ICalDataType.URI);
        this.registerParameterDataType("CN", ICalDataType.TEXT);
        this.registerParameterDataType("CUTYPE", ICalDataType.TEXT);
        this.registerParameterDataType("DELEGATED-FROM", ICalDataType.CAL_ADDRESS);
        this.registerParameterDataType("DELEGATED-TO", ICalDataType.CAL_ADDRESS);
        this.registerParameterDataType("DIR", ICalDataType.URI);
        this.registerParameterDataType("DISPLAY", ICalDataType.TEXT);
        this.registerParameterDataType("EMAIL", ICalDataType.TEXT);
        this.registerParameterDataType("ENCODING", ICalDataType.TEXT);
        this.registerParameterDataType("FEATURE", ICalDataType.TEXT);
        this.registerParameterDataType("FMTTYPE", ICalDataType.TEXT);
        this.registerParameterDataType("FBTYPE", ICalDataType.TEXT);
        this.registerParameterDataType("LABEL", ICalDataType.TEXT);
        this.registerParameterDataType("LANGUAGE", ICalDataType.TEXT);
        this.registerParameterDataType("MEMBER", ICalDataType.CAL_ADDRESS);
        this.registerParameterDataType("PARTSTAT", ICalDataType.TEXT);
        this.registerParameterDataType("RANGE", ICalDataType.TEXT);
        this.registerParameterDataType("RELATED", ICalDataType.TEXT);
        this.registerParameterDataType("RELTYPE", ICalDataType.TEXT);
        this.registerParameterDataType("ROLE", ICalDataType.TEXT);
        this.registerParameterDataType("RSVP", ICalDataType.BOOLEAN);
        this.registerParameterDataType("SENT-BY", ICalDataType.CAL_ADDRESS);
        this.registerParameterDataType("TZID", ICalDataType.TEXT);
    }

    @Override
    protected ICalVersion getTargetVersion() {
        return this.targetVersion;
    }

    public void registerParameterDataType(String parameterName, ICalDataType dataType) {
        parameterName = parameterName.toLowerCase();
        if (dataType == null) {
            this.parameterDataTypes.remove(parameterName);
        } else {
            this.parameterDataTypes.put(parameterName, dataType);
        }
    }
}

