/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.ooxml;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipException;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.openxml4j.opc.PackageRelationshipCollection;
import org.apache.poi.xssf.usermodel.XSSFRelation;
import org.apache.poi.xwpf.usermodel.XWPFNumbering;
import org.apache.poi.xwpf.usermodel.XWPFRelation;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.microsoft.ooxml.AbstractOOXMLExtractor;
import org.apache.tika.parser.microsoft.ooxml.OOXMLTikaBodyPartHandler;
import org.apache.tika.parser.microsoft.ooxml.OOXMLWordAndPowerPointTextHandler;
import org.apache.tika.parser.microsoft.ooxml.XWPFListManager;
import org.apache.tika.parser.microsoft.ooxml.xwpf.XWPFEventBasedWordExtractor;
import org.apache.tika.parser.microsoft.ooxml.xwpf.XWPFNumberingShim;
import org.apache.tika.parser.microsoft.ooxml.xwpf.XWPFStylesShim;
import org.apache.tika.sax.EmbeddedContentHandler;
import org.apache.tika.sax.OfflineContentHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.apache.tika.utils.ExceptionUtils;
import org.apache.tika.utils.XMLReaderUtils;
import org.apache.xmlbeans.XmlException;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SXWPFWordExtractorDecorator
extends AbstractOOXMLExtractor {
    private static final String[] MAIN_PART_RELATIONS = new String[]{XWPFRelation.HEADER.getRelation(), XWPFRelation.FOOTER.getRelation(), XWPFRelation.FOOTNOTE.getRelation(), "http://schemas.openxmlformats.org/officeDocument/2006/relationships/endnotes", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/comments"};
    private static final String[] MAIN_STORY_PART_RELATIONS = new String[]{XWPFRelation.DOCUMENT.getContentType(), XWPFRelation.MACRO_DOCUMENT.getContentType(), XWPFRelation.TEMPLATE.getContentType(), XWPFRelation.MACRO_TEMPLATE_DOCUMENT.getContentType()};
    private final OPCPackage opcPackage;
    private final ParseContext context;
    private final Metadata metadata;

    public SXWPFWordExtractorDecorator(Metadata metadata, ParseContext context, XWPFEventBasedWordExtractor extractor) {
        super(context, extractor);
        this.metadata = metadata;
        this.context = context;
        this.opcPackage = extractor.getPackage();
    }

    @Override
    protected void buildXHTML(XHTMLContentHandler xhtml) throws SAXException, XmlException, IOException {
        ArrayList pps = this.getStoryDocumentParts();
        if (pps != null) {
            for (PackagePart pp : pps) {
                this.handleDocumentPart(pp, xhtml);
            }
        }
        if ((pps = this.opcPackage.getPartsByContentType(XWPFRelation.GLOSSARY_DOCUMENT.getContentType())) != null && pps.size() > 0) {
            xhtml.startElement("div", "class", "glossary");
            for (PackagePart pp : pps) {
                this.handleDocumentPart(pp, xhtml);
            }
            xhtml.endElement("div");
        }
    }

    private void handleDocumentPart(PackagePart documentPart, XHTMLContentHandler xhtml) throws IOException, SAXException {
        XWPFNumbering numbering = this.loadNumbering(documentPart);
        XWPFListManager listManager = new XWPFListManager(numbering);
        XWPFStylesShim styles = null;
        try {
            styles = this.loadStyles(documentPart);
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (Exception e) {
            this.metadata.add(TikaCoreProperties.TIKA_META_EXCEPTION_WARNING, ExceptionUtils.getStackTrace((Throwable)e));
        }
        if (this.config.isIncludeHeadersAndFooters()) {
            try {
                PackageRelationshipCollection headersPRC = documentPart.getRelationshipsByType(XWPFRelation.HEADER.getRelation());
                if (headersPRC != null) {
                    for (int i = 0; i < headersPRC.size(); ++i) {
                        PackagePart header = documentPart.getRelatedPart(headersPRC.getRelationship(i));
                        this.handlePart(header, styles, listManager, xhtml);
                    }
                }
            }
            catch (ZipException | InvalidFormatException e) {
                this.metadata.add(TikaCoreProperties.TIKA_META_EXCEPTION_WARNING, ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        try {
            this.handlePart(documentPart, styles, listManager, xhtml);
        }
        catch (ZipException e) {
            this.metadata.add(TikaCoreProperties.TIKA_META_EXCEPTION_WARNING, ExceptionUtils.getStackTrace((Throwable)e));
        }
        for (String rel : new String[]{"http://schemas.openxmlformats.org/officeDocument/2006/relationships/diagramData", XSSFRelation.CHART.getRelation(), XWPFRelation.FOOTNOTE.getRelation(), XWPFRelation.COMMENT.getRelation(), XWPFRelation.FOOTER.getRelation(), XWPFRelation.ENDNOTE.getRelation()}) {
            if (!this.config.isIncludeHeadersAndFooters() && rel.equals(XWPFRelation.FOOTER.getRelation())) continue;
            try {
                PackageRelationshipCollection prc = documentPart.getRelationshipsByType(rel);
                if (prc == null) continue;
                for (int i = 0; i < prc.size(); ++i) {
                    PackagePart packagePart = documentPart.getRelatedPart(prc.getRelationship(i));
                    this.handlePart(packagePart, styles, listManager, xhtml);
                }
            }
            catch (ZipException | InvalidFormatException e) {
                this.metadata.add(TikaCoreProperties.TIKA_META_EXCEPTION_WARNING, ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
    }

    private void handlePart(PackagePart packagePart, XWPFStylesShim styles, XWPFListManager listManager, XHTMLContentHandler xhtml) throws IOException, SAXException {
        Map<String, String> linkedRelationships = this.loadLinkedRelationships(packagePart, true, this.metadata);
        try (InputStream stream = packagePart.getInputStream();){
            XMLReaderUtils.parseSAX((InputStream)new CloseShieldInputStream(stream), (DefaultHandler)new OfflineContentHandler((ContentHandler)new EmbeddedContentHandler((ContentHandler)new OOXMLWordAndPowerPointTextHandler(new OOXMLTikaBodyPartHandler(xhtml, styles, listManager, this.config), linkedRelationships, this.config.isIncludeShapeBasedContent(), this.config.isConcatenatePhoneticRuns()))), (ParseContext)this.context);
        }
        catch (IOException | TikaException e) {
            this.metadata.add(TikaCoreProperties.TIKA_META_EXCEPTION_WARNING, ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    private XWPFStylesShim loadStyles(PackagePart packagePart) throws InvalidFormatException, TikaException, IOException, SAXException {
        PackageRelationshipCollection stylesParts = packagePart.getRelationshipsByType(XWPFRelation.STYLES.getRelation());
        if (stylesParts.size() > 0) {
            PackageRelationship stylesRelationShip = stylesParts.getRelationship(0);
            if (stylesRelationShip == null) {
                return null;
            }
            PackagePart stylesPart = packagePart.getRelatedPart(stylesRelationShip);
            if (stylesPart == null) {
                return null;
            }
            return new XWPFStylesShim(stylesPart, this.context);
        }
        return null;
    }

    private XWPFNumbering loadNumbering(PackagePart packagePart) {
        try {
            PackageRelationshipCollection numberingParts = packagePart.getRelationshipsByType(XWPFRelation.NUMBERING.getRelation());
            if (numberingParts.size() > 0) {
                PackageRelationship numberingRelationShip = numberingParts.getRelationship(0);
                if (numberingRelationShip == null) {
                    return null;
                }
                PackagePart numberingPart = packagePart.getRelatedPart(numberingRelationShip);
                if (numberingPart == null) {
                    return null;
                }
                return new XWPFNumberingShim(numberingPart);
            }
        }
        catch (IOException | OpenXML4JException throwable) {
            // empty catch block
        }
        return null;
    }

    @Override
    protected List<PackagePart> getMainDocumentParts() {
        List<PackagePart> mainStoryDocs = this.getStoryDocumentParts();
        ArrayList<PackagePart> relatedParts = new ArrayList<PackagePart>();
        mainStoryDocs.addAll(this.opcPackage.getPartsByContentType(XWPFRelation.GLOSSARY_DOCUMENT.getContentType()));
        for (PackagePart pp : mainStoryDocs) {
            this.addRelatedParts(pp, relatedParts);
        }
        relatedParts.addAll(mainStoryDocs);
        return relatedParts;
    }

    private void addRelatedParts(PackagePart documentPart, List<PackagePart> relatedParts) {
        for (String relation : MAIN_PART_RELATIONS) {
            PackageRelationshipCollection prc = null;
            try {
                prc = documentPart.getRelationshipsByType(relation);
                if (prc == null) continue;
                for (int i = 0; i < prc.size(); ++i) {
                    PackagePart packagePart = documentPart.getRelatedPart(prc.getRelationship(i));
                    relatedParts.add(packagePart);
                }
            }
            catch (InvalidFormatException invalidFormatException) {
                // empty catch block
            }
        }
    }

    private List<PackagePart> getStoryDocumentParts() {
        for (String contentType : MAIN_STORY_PART_RELATIONS) {
            ArrayList pps = this.opcPackage.getPartsByContentType(contentType);
            if (pps.size() <= 0) continue;
            return pps;
        }
        return new ArrayList<PackagePart>();
    }
}

