/*
 * Decompiled with CFR 0.152.
 */
package org.obolibrary.oboformat.parser;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.obolibrary.oboformat.model.Clause;
import org.obolibrary.oboformat.model.Frame;
import org.obolibrary.oboformat.model.FrameMergeException;
import org.obolibrary.oboformat.model.OBODoc;
import org.obolibrary.oboformat.model.QualifierValue;
import org.obolibrary.oboformat.model.Xref;
import org.obolibrary.oboformat.parser.OBOFormatConstants;
import org.obolibrary.oboformat.parser.OBOFormatParserException;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OBOFormatParser {
    private static final String BRACE = " !{";
    static final Logger LOG = LoggerFactory.getLogger(OBOFormatParser.class);
    protected final MyStream stream;
    private final LoadingCache<String, String> stringCache;
    private boolean followImport;
    private Object location;
    private final ConcurrentHashMap<String, OBODoc> importCache = new ConcurrentHashMap();

    public OBOFormatParser() {
        this(new MyStream(), Collections.emptyMap());
    }

    public OBOFormatParser(Map<String, OBODoc> importsMap) {
        this(new MyStream(), importsMap);
    }

    protected OBOFormatParser(MyStream s, Map<String, OBODoc> importsMap) {
        this.stream = s;
        this.importCache.putAll(importsMap);
        Caffeine builder = Caffeine.newBuilder().maximumWeight(0x800000L).weigher((key, value) -> key.length());
        if (LOG.isDebugEnabled()) {
            builder.recordStats();
        }
        this.stringCache = builder.build(key -> key);
    }

    private static void addOboNamespace(@Nullable Collection<Frame> frames, String defaultOboNamespace) {
        if (frames != null && !frames.isEmpty()) {
            for (Frame termFrame : frames) {
                Clause clause = termFrame.getClause(OBOFormatConstants.OboFormatTag.TAG_NAMESPACE);
                if (clause != null) continue;
                clause = new Clause(OBOFormatConstants.OboFormatTag.TAG_NAMESPACE, defaultOboNamespace);
                termFrame.addClause(clause);
            }
        }
    }

    private static String mapDeprecatedTag(String tag) {
        if ("inverse_of_on_instance_level".equals(tag)) {
            return OBOFormatConstants.OboFormatTag.TAG_INVERSE_OF.getTag();
        }
        if ("xref_analog".equals(tag)) {
            return OBOFormatConstants.OboFormatTag.TAG_XREF.getTag();
        }
        if ("xref_unknown".equals(tag)) {
            return OBOFormatConstants.OboFormatTag.TAG_XREF.getTag();
        }
        if ("instance_level_is_transitive".equals(tag)) {
            return OBOFormatConstants.OboFormatTag.TAG_IS_TRANSITIVE.getTag();
        }
        return tag;
    }

    private static String removeTrailingWS(String s) {
        return s.replaceAll("\\s*$", "");
    }

    public boolean addImport(String key, OBODoc doc) {
        return this.importCache.put(key, doc) == null;
    }

    public void setReader(BufferedReader r) {
        this.stream.reader = r;
    }

    public boolean getFollowImports() {
        return this.followImport;
    }

    public void setFollowImports(boolean followImports) {
        this.followImport = followImports;
    }

    public OBODoc parse(String fn) throws IOException {
        if (fn.startsWith("http:")) {
            return this.parse(new URL(fn));
        }
        return this.parse(new File(fn));
    }

    /*
     * Exception decompiling
     */
    public OBODoc parse(File file) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public OBODoc parse(URL url) throws IOException {
        this.location = url;
        BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8));
        return this.parse(in);
    }

    public OBODoc parseURL(String urlstr) throws IOException {
        URL url = new URL(urlstr);
        return this.parse(url);
    }

    private String resolvePath(String inputPath) {
        String path = inputPath;
        if (!(path.startsWith("http:") || path.startsWith("file:") || path.startsWith("https:") || this.location == null)) {
            if (this.location instanceof URL) {
                URL url = (URL)this.location;
                String p = url.toString();
                int index = p.lastIndexOf(47);
                path = p.substring(0, index + 1) + path;
            } else {
                File f = new File(this.location.toString());
                f = new File(f.getParent(), path);
                path = f.toURI().toString();
            }
        }
        return path;
    }

    public OBODoc parse(Reader reader) throws IOException {
        this.setReader(new BufferedReader(reader));
        OBODoc obodoc = new OBODoc();
        this.parseOBODoc(obodoc);
        Frame hf = obodoc.getHeaderFrame();
        LinkedList<OBODoc> imports = new LinkedList<OBODoc>();
        if (hf != null) {
            for (Clause cl : hf.getClauses(OBOFormatConstants.OboFormatTag.TAG_IMPORT)) {
                String path = this.resolvePath(cl.getValue(String.class));
                cl.setValue(path);
                if (!this.followImport) continue;
                OBODoc doc = this.importCache.get(path);
                if (doc == null) {
                    OBOFormatParser parser = new OBOFormatParser(this.importCache);
                    doc = parser.parseURL(path);
                }
                imports.add(doc);
            }
            obodoc.setImportedOBODocs(imports);
        }
        return obodoc;
    }

    public void parseOBODoc(OBODoc obodoc) {
        Frame h = new Frame(Frame.FrameType.HEADER);
        obodoc.setHeaderFrame(h);
        this.parseHeaderFrame(h);
        h.freeze();
        this.parseZeroOrMoreWsOptCmtNl();
        while (!this.stream.eof()) {
            this.parseEntityFrame(obodoc);
            this.parseZeroOrMoreWsOptCmtNl();
        }
        String defaultOboNamespace = h.getTagValue(OBOFormatConstants.OboFormatTag.TAG_DEFAULT_NAMESPACE, String.class);
        if (defaultOboNamespace != null) {
            OBOFormatParser.addOboNamespace(obodoc.getTermFrames(), defaultOboNamespace);
            OBOFormatParser.addOboNamespace(obodoc.getTypedefFrames(), defaultOboNamespace);
            OBOFormatParser.addOboNamespace(obodoc.getInstanceFrames(), defaultOboNamespace);
        }
    }

    public List<String> checkDanglingReferences(OBODoc doc) {
        Clause c;
        ArrayList<String> danglingReferences = new ArrayList<String>();
        for (Frame f : doc.getTermFrames()) {
            for (String tag : f.getTags()) {
                OBOFormatConstants.OboFormatTag tagconstant = OBOFormatConstants.getTag(tag);
                c = f.getClause(tag);
                this.validate(doc, danglingReferences, f, tag, tagconstant, c);
            }
        }
        for (Frame f : doc.getTypedefFrames()) {
            for (String tag : f.getTags()) {
                OBOFormatConstants.OboFormatTag tagConstant = OBOFormatConstants.getTag(tag);
                c = f.getClause(tag);
                this.validate1(doc, danglingReferences, f, tag, tagConstant, c);
            }
        }
        return danglingReferences;
    }

    protected void validate1(OBODoc doc, List<String> danglingReferences, Frame f, String tag, @Nullable OBOFormatConstants.OboFormatTag tagConstant, @Nullable Clause c) {
        if (c != null) {
            String error;
            if (OBOFormatConstants.OboFormatTag.TYPEDEF_FRAMES.contains((Object)tagConstant)) {
                String error2 = this.checkRelation(c.getValue(String.class), tag, f.getId(), doc);
                if (error2 != null) {
                    danglingReferences.add(error2);
                }
            } else if (tagConstant == OBOFormatConstants.OboFormatTag.TAG_HOLDS_OVER_CHAIN || tagConstant == OBOFormatConstants.OboFormatTag.TAG_EQUIVALENT_TO_CHAIN || tagConstant == OBOFormatConstants.OboFormatTag.TAG_RELATIONSHIP) {
                String error3 = this.checkRelation(c.getValue(String.class), tag, f.getId(), doc);
                if (error3 != null) {
                    danglingReferences.add(error3);
                }
                if ((error3 = this.checkRelation(c.getValue2(String.class), tag, f.getId(), doc)) != null) {
                    danglingReferences.add(error3);
                }
            } else if ((tagConstant == OBOFormatConstants.OboFormatTag.TAG_DOMAIN || tagConstant == OBOFormatConstants.OboFormatTag.TAG_RANGE) && (error = this.checkClassReference(c.getValue(String.class), tag, f.getId(), doc)) != null) {
                danglingReferences.add(error);
            }
        }
    }

    protected void validate(OBODoc doc, List<String> danglingReferences, Frame f, String tag, @Nullable OBOFormatConstants.OboFormatTag tagconstant, @Nullable Clause c) {
        if (c != null && OBOFormatConstants.OboFormatTag.TERM_FRAMES.contains((Object)tagconstant)) {
            if (c.getValues().size() > 1) {
                String error = this.checkRelation(c.getValue(String.class), tag, f.getId(), doc);
                if (error != null) {
                    danglingReferences.add(error);
                }
                if ((error = this.checkClassReference(c.getValue2(String.class), tag, f.getId(), doc)) != null) {
                    danglingReferences.add(error);
                }
            } else {
                String error = this.checkClassReference(c.getValue(String.class), tag, f.getId(), doc);
                if (error != null) {
                    danglingReferences.add(error);
                }
            }
        }
    }

    @Nullable
    private String checkRelation(String relId, String tag, @Nullable String frameId, OBODoc doc) {
        if (doc.getTypedefFrame(relId, this.followImport) == null) {
            return "The relation '" + relId + "' reference in the tag '" + tag + " ' in the frame of id '" + frameId + "' is not declared";
        }
        return null;
    }

    @Nullable
    private String checkClassReference(String classId, String tag, @Nullable String frameId, OBODoc doc) {
        if (doc.getTermFrame(classId, this.followImport) == null) {
            return "The class '" + classId + "' reference in the tag '" + tag + " ' in the frame of id '" + frameId + "'is not declared";
        }
        return null;
    }

    public void parseHeaderFrame(Frame h) {
        while (this.parseHeaderClauseNl(h)) {
        }
    }

    protected boolean parseHeaderClauseNl(Frame h) {
        this.parseZeroOrMoreWsOptCmtNl();
        if (this.stream.peekCharIs('[') || this.stream.eof()) {
            return false;
        }
        this.parseHeaderClause(h);
        this.parseHiddenComment();
        this.forceParseNlOrEof();
        return true;
    }

    protected Clause parseHeaderClause(Frame h) {
        String t = this.getParseTag();
        Clause cl = new Clause(t);
        OBOFormatConstants.OboFormatTag tag = OBOFormatConstants.getTag(t);
        h.addClause(cl);
        if (tag == null) {
            return this.parseUnquotedString(cl);
        }
        switch (tag) {
            case TAG_SYNONYMTYPEDEF: {
                return this.parseSynonymTypedef(cl);
            }
            case TAG_SUBSETDEF: {
                return this.parseSubsetdef(cl);
            }
            case TAG_DATE: {
                return this.parseHeaderDate(cl);
            }
            case TAG_PROPERTY_VALUE: {
                this.parsePropertyValue(cl);
                return this.parseQualifierAndHiddenComment(cl);
            }
            case TAG_IMPORT: {
                return this.parseImport(cl);
            }
            case TAG_IDSPACE: {
                return this.parseIdSpace(cl);
            }
        }
        return this.parseUnquotedString(cl);
    }

    protected Clause parseQualifierAndHiddenComment(Clause cl) {
        this.parseZeroOrMoreWs();
        this.parseQualifierBlock(cl);
        this.parseHiddenComment();
        return cl;
    }

    public void parseEntityFrame(OBODoc obodoc) {
        this.parseZeroOrMoreWsOptCmtNl();
        String rest = this.stream.rest();
        if (rest.startsWith("[Term]")) {
            this.parseTermFrame(obodoc);
        } else if (rest.startsWith("[Instance]")) {
            LOG.error("Error: Instance frames are not supported yet. Parsing stopped at line: {}", (Object)this.stream.getLineNo());
            while (!this.stream.eof()) {
                this.stream.advanceLine();
            }
        } else {
            this.parseTypedefFrame(obodoc);
        }
    }

    public void parseTermFrame(OBODoc obodoc) {
        Frame f = new Frame(Frame.FrameType.TERM);
        this.parseZeroOrMoreWsOptCmtNl();
        if (this.stream.consume("[Term]")) {
            this.forceParseNlOrEof();
            this.parseIdLine(f);
            this.parseZeroOrMoreWsOptCmtNl();
            while (!this.stream.eof() && !this.stream.peekCharIs('[')) {
                this.parseTermFrameClauseEOL(f);
                this.parseZeroOrMoreWsOptCmtNl();
            }
            try {
                f.freeze();
                obodoc.addFrame(f);
            }
            catch (FrameMergeException e) {
                throw new OBOFormatParserException("Could not add frame " + f + " to document, duplicate frame definition?", e, this.stream.lineNo, this.stream.line);
            }
        } else {
            this.error("Expected a [Term] frame, but found unknown stanza type.");
        }
    }

    protected void parseTermFrameClauseEOL(Frame f) {
        if (this.stream.peekCharIs('!')) {
            this.parseHiddenComment();
            this.forceParseNlOrEof();
        } else {
            Clause cl = this.parseTermFrameClause();
            this.parseEOL(cl);
            f.addClause(cl);
        }
    }

    public Clause parseTermFrameClause() {
        Clause cl;
        String t = this.getParseTag();
        if (this.parseDeprecatedSynonym(t, cl = new Clause(t))) {
            return cl;
        }
        OBOFormatConstants.OboFormatTag tag = OBOFormatConstants.getTag(t);
        if (tag == null) {
            return this.parseCustomTag(cl);
        }
        switch (tag) {
            case TAG_IS_ANONYMOUS: 
            case TAG_BUILTIN: 
            case TAG_IS_OBSELETE: {
                return this.parseBoolean(cl);
            }
            case TAG_NAME: 
            case TAG_COMMENT: 
            case TAG_CREATED_BY: {
                return this.parseUnquotedString(cl);
            }
            case TAG_NAMESPACE: 
            case TAG_ALT_ID: 
            case TAG_IS_A: 
            case TAG_UNION_OF: 
            case TAG_EQUIVALENT_TO: 
            case TAG_DISJOINT_FROM: 
            case TAG_REPLACED_BY: 
            case TAG_CONSIDER: {
                return this.parseIdRef(cl);
            }
            case TAG_DEF: {
                return this.parseDef(cl);
            }
            case TAG_SUBSET: {
                return this.parseUnquotedString(cl);
            }
            case TAG_SYNONYM: {
                return this.parseSynonym(cl);
            }
            case TAG_XREF: {
                return this.parseDirectXref(cl);
            }
            case TAG_PROPERTY_VALUE: {
                return this.parsePropertyValue(cl);
            }
            case TAG_INTERSECTION_OF: {
                return this.parseTermIntersectionOf(cl);
            }
            case TAG_RELATIONSHIP: {
                return this.parseRelationship(cl);
            }
            case TAG_CREATION_DATE: {
                return this.parseISODate(cl);
            }
        }
        return this.parseCustomTag(cl);
    }

    public void parseTypedefFrame(OBODoc obodoc) {
        Frame f = new Frame(Frame.FrameType.TYPEDEF);
        this.parseZeroOrMoreWsOptCmtNl();
        if (this.stream.consume("[Typedef]")) {
            this.forceParseNlOrEof();
            this.parseIdLine(f);
            this.parseZeroOrMoreWsOptCmtNl();
            while (!this.stream.eof() && !this.stream.peekCharIs('[')) {
                this.parseTypedefFrameClauseEOL(f);
                this.parseZeroOrMoreWsOptCmtNl();
            }
            try {
                f.freeze();
                obodoc.addFrame(f);
            }
            catch (FrameMergeException e) {
                throw new OBOFormatParserException("Could not add frame " + f + " to document, duplicate frame definition?", e, this.stream.lineNo, this.stream.line);
            }
        } else {
            this.error("Expected a [Typedef] frame, but found unknown stanza type.");
        }
    }

    protected void parseTypedefFrameClauseEOL(Frame f) {
        if (this.stream.peekCharIs('!')) {
            this.parseHiddenComment();
            this.forceParseNlOrEof();
        } else {
            Clause cl = this.parseTypedefFrameClause();
            this.parseEOL(cl);
            f.addClause(cl);
        }
    }

    public Clause parseTypedefFrameClause() {
        Clause cl;
        String t = this.getParseTag();
        if ("is_metadata".equals(t)) {
            LOG.info("is_metadata DEPRECATED; switching to is_metadata_tag");
            t = OBOFormatConstants.OboFormatTag.TAG_IS_METADATA_TAG.getTag();
        }
        if (this.parseDeprecatedSynonym(t, cl = new Clause(t))) {
            return cl;
        }
        OBOFormatConstants.OboFormatTag tag = OBOFormatConstants.getTag(t);
        if (tag == null) {
            return this.parseCustomTag(cl);
        }
        switch (tag) {
            case TAG_IS_ANONYMOUS: 
            case TAG_BUILTIN: 
            case TAG_IS_OBSELETE: 
            case TAG_IS_ANTI_SYMMETRIC: 
            case TAG_IS_CYCLIC: 
            case TAG_IS_REFLEXIVE: 
            case TAG_IS_SYMMETRIC: 
            case TAG_IS_ASYMMETRIC: 
            case TAG_IS_TRANSITIVE: 
            case TAG_IS_FUNCTIONAL: 
            case TAG_IS_INVERSE_FUNCTIONAL: 
            case TAG_IS_METADATA_TAG: 
            case TAG_IS_CLASS_LEVEL_TAG: {
                return this.parseBoolean(cl);
            }
            case TAG_NAME: 
            case TAG_COMMENT: 
            case TAG_CREATED_BY: {
                return this.parseUnquotedString(cl);
            }
            case TAG_NAMESPACE: 
            case TAG_ALT_ID: 
            case TAG_IS_A: 
            case TAG_UNION_OF: 
            case TAG_EQUIVALENT_TO: 
            case TAG_DISJOINT_FROM: 
            case TAG_REPLACED_BY: 
            case TAG_CONSIDER: 
            case TAG_SUBSET: 
            case TAG_INVERSE_OF: 
            case TAG_TRANSITIVE_OVER: 
            case TAG_DISJOINT_OVER: 
            case TAG_DOMAIN: 
            case TAG_RANGE: {
                return this.parseIdRef(cl);
            }
            case TAG_DEF: {
                return this.parseDef(cl);
            }
            case TAG_SYNONYM: {
                return this.parseSynonym(cl);
            }
            case TAG_XREF: {
                return this.parseDirectXref(cl);
            }
            case TAG_PROPERTY_VALUE: {
                return this.parsePropertyValue(cl);
            }
            case TAG_INTERSECTION_OF: {
                return this.parseTypedefIntersectionOf(cl);
            }
            case TAG_RELATIONSHIP: {
                return this.parseRelationship(cl);
            }
            case TAG_CREATION_DATE: {
                return this.parseISODate(cl);
            }
            case TAG_HOLDS_OVER_CHAIN: 
            case TAG_EQUIVALENT_TO_CHAIN: {
                return this.parseIdRefPair(cl);
            }
            case TAG_EXPAND_ASSERTION_TO: 
            case TAG_EXPAND_EXPRESSION_TO: {
                return this.parseOwlDef(cl);
            }
        }
        return this.parseCustomTag(cl);
    }

    private String getParseTag() {
        int i;
        if (this.stream.eof()) {
            this.error("Expected an id tag, not end of file.");
        }
        if (this.stream.eol()) {
            this.error("Expected an id tag, not end of line");
        }
        if ((i = this.stream.indexOf(':')) == -1) {
            this.error("Could not find tag separator ':' in line.");
        }
        String tag = this.stream.rest().substring(0, i);
        this.stream.advance(i + 1);
        this.parseWs();
        this.parseZeroOrMoreWs();
        OBOFormatConstants.OboFormatTag formatTag = OBOFormatConstants.getTag(tag);
        if (formatTag != null) {
            tag = formatTag.getTag();
        }
        return OBOFormatParser.mapDeprecatedTag(tag);
    }

    private Clause parseIdRef(Clause cl) {
        return this.parseIdRef(cl, false);
    }

    private Clause parseIdRef(Clause cl, boolean optional) {
        String id = this.getParseUntil(BRACE);
        if (!optional && id.length() < 1) {
            this.error("");
        }
        cl.addValue(id);
        return cl;
    }

    private Clause parseIdRefPair(Clause cl) {
        this.parseIdRef(cl);
        this.parseOneOrMoreWs();
        return this.parseIdRef(cl);
    }

    private Clause parseISODate(Clause cl) {
        String dateStr = this.getParseUntil(BRACE);
        cl.setValue(dateStr);
        return cl;
    }

    private Clause parseSubsetdef(Clause cl) {
        this.parseIdRef(cl);
        this.parseOneOrMoreWs();
        if (this.stream.consume("\"")) {
            String desc = this.getParseUntilAdv("\"");
            cl.addValue(desc);
        } else {
            this.error("");
        }
        return this.parseQualifierAndHiddenComment(cl);
    }

    private Clause parseSynonymTypedef(Clause cl) {
        this.parseIdRef(cl);
        this.parseOneOrMoreWs();
        if (this.stream.consume("\"")) {
            String desc = this.getParseUntilAdv("\"");
            cl.addValue(desc);
            if (this.stream.peekCharIs(' ')) {
                this.parseOneOrMoreWs();
                this.parseIdRef(cl, true);
            }
        }
        return this.parseQualifierAndHiddenComment(cl);
    }

    private Clause parseHeaderDate(Clause cl) {
        this.parseZeroOrMoreWs();
        String v = this.getParseUntil("!");
        v = OBOFormatParser.removeTrailingWS(v);
        try {
            Date date = OBOFormatConstants.headerDateFormat().parse(v);
            cl.addValue(date);
            return cl;
        }
        catch (ParseException e) {
            throw new OBOFormatParserException("Could not parse date from string: " + v, e, this.stream.lineNo, this.stream.line);
        }
    }

    private Clause parseImport(Clause cl) {
        this.parseZeroOrMoreWs();
        String v = this.getParseUntil("!{");
        v = OBOFormatParser.removeTrailingWS(v);
        cl.setValue(v);
        this.parseZeroOrMoreWs();
        if (this.stream.peekCharIs('{')) {
            this.getParseUntilAdv("}");
        }
        this.parseHiddenComment();
        return cl;
    }

    private Clause parseIdSpace(Clause cl) {
        this.parseZeroOrMoreWs();
        this.parseIdRefPair(cl);
        this.parseZeroOrMoreWs();
        if (this.stream.peekCharIs('\"')) {
            this.stream.consume("\"");
            String desc = this.getParseUntilAdv("\"");
            cl.addValue(desc);
        } else {
            String desc = this.getParseUntil(BRACE);
            cl.addValue(desc);
        }
        return this.parseQualifierAndHiddenComment(cl);
    }

    private Clause parseRelationship(Clause cl) {
        this.parseIdRef(cl);
        this.parseOneOrMoreWs();
        return this.parseIdRef(cl);
    }

    private Clause parsePropertyValue(Clause cl) {
        String desc;
        if (this.stream.peekCharIs('\"')) {
            this.stream.consume("\"");
            desc = this.getParseUntilAdv("\"");
            cl.addValue(desc);
        } else {
            this.parseIdRef(cl);
        }
        this.parseOneOrMoreWs();
        if (this.stream.peekCharIs('\"')) {
            this.stream.consume("\"");
            desc = this.getParseUntilAdv("\"");
            cl.addValue(desc);
        } else {
            this.parseIdRef(cl);
        }
        this.parseZeroOrMoreWs();
        if (this.stream.peekCharIs('\"')) {
            this.stream.consume("\"");
            desc = this.getParseUntilAdv("\"");
            cl.addValue(desc);
        } else {
            String s = this.getParseUntil(BRACE);
            if (!s.isEmpty()) {
                cl.addValue(s);
            }
        }
        return cl;
    }

    private Clause parseTermIntersectionOf(Clause cl) {
        char c;
        this.parseIdRef(cl);
        this.parseZeroOrMoreWs();
        if (!this.stream.eol() && (c = this.stream.peekChar()) != '!' && c != '{') {
            this.parseIdRef(cl, true);
        }
        return cl;
    }

    private Clause parseTypedefIntersectionOf(Clause cl) {
        return this.parseIdRef(cl);
    }

    private boolean parseDeprecatedSynonym(String tag, Clause cl) {
        String scope;
        if ("exact_synonym".equals(tag)) {
            scope = OBOFormatConstants.OboFormatTag.TAG_EXACT.getTag();
        } else if ("narrow_synonym".equals(tag)) {
            scope = OBOFormatConstants.OboFormatTag.TAG_NARROW.getTag();
        } else if ("broad_synonym".equals(tag)) {
            scope = OBOFormatConstants.OboFormatTag.TAG_BROAD.getTag();
        } else if ("related_synonym".equals(tag)) {
            scope = OBOFormatConstants.OboFormatTag.TAG_RELATED.getTag();
        } else {
            return false;
        }
        cl.setTag(OBOFormatConstants.OboFormatTag.TAG_SYNONYM.getTag());
        if (this.stream.consume("\"")) {
            String syn = this.getParseUntilAdv("\"");
            cl.setValue(syn);
            cl.addValue(scope);
            this.parseZeroOrMoreWs();
            this.parseXrefList(cl, false);
            return true;
        }
        return false;
    }

    private Clause parseSynonym(Clause cl) {
        if (this.stream.consume("\"")) {
            String syn = this.getParseUntilAdv("\"");
            cl.setValue(syn);
            this.parseZeroOrMoreWs();
            if (!this.stream.peekCharIs('[')) {
                this.parseIdRef(cl, true);
                this.parseZeroOrMoreWs();
                if (!this.stream.peekCharIs('[')) {
                    this.parseIdRef(cl, true);
                    this.parseZeroOrMoreWs();
                }
            }
            this.parseXrefList(cl, false);
        } else {
            this.error("The synonym is always a quoted string.");
        }
        return cl;
    }

    private Clause parseDef(Clause cl) {
        if (this.stream.consume("\"")) {
            String def = this.getParseUntilAdv("\"");
            cl.setValue(def);
            this.parseZeroOrMoreWs();
            this.parseXrefList(cl, true);
        } else {
            this.error("Definitions should always be a quoted string.");
        }
        return cl;
    }

    private Clause parseOwlDef(Clause cl) {
        if (this.stream.consume("\"")) {
            String def = this.getParseUntilAdv("\"");
            cl.setValue(def);
            this.parseZeroOrMoreWs();
            this.parseXrefList(cl, true);
        } else {
            this.error("The " + cl.getTag() + " clause is always a quoted string.");
        }
        return cl;
    }

    private void parseXrefList(Clause cl, boolean optional) {
        if (this.stream.consume("[")) {
            this.parseZeroOrMoreXrefs(cl);
            this.parseZeroOrMoreWs();
            if (!this.stream.consume("]")) {
                this.error("Missing closing ']' for xref list at pos: " + this.stream.pos);
            }
        } else if (!optional) {
            this.error("Clause: " + cl.getTag() + "; expected an xref list, or at least an empty list '[]' at pos: " + this.stream.pos);
        }
    }

    private boolean parseZeroOrMoreXrefs(Clause cl) {
        if (this.parseXref(cl)) {
            while (this.stream.consume(",") && this.parseXref(cl)) {
            }
        }
        return true;
    }

    private boolean parseXref(Clause cl) {
        this.parseZeroOrMoreWs();
        String id = this.getParseUntil("\",]!{", true);
        if (!id.isEmpty()) {
            if ((id = OBOFormatParser.removeTrailingWS(id)).contains(" ")) {
                this.warn("accepting bad xref with spaces:" + id);
            }
            Xref xref = new Xref(id);
            cl.addXref(xref);
            this.parseZeroOrMoreWs();
            if (this.stream.peekCharIs('\"')) {
                this.stream.consume("\"");
                xref.setAnnotation(this.getParseUntilAdv("\""));
            }
            this.parseZeroOrMoreWs();
            this.parseQualifierBlock(cl);
            return true;
        }
        return false;
    }

    private Clause parseDirectXref(Clause cl) {
        this.parseZeroOrMoreWs();
        String id = this.getParseUntil("\",]!{", true);
        id = id.trim();
        if (id.contains(" ")) {
            this.warn("accepting bad xref with spaces:<" + id + '>');
        }
        id = id.replaceAll(" +\\Z", "");
        Xref xref = new Xref(id);
        cl.addValue(xref);
        this.parseZeroOrMoreWs();
        if (this.stream.peekCharIs('\"')) {
            this.stream.consume("\"");
            xref.setAnnotation(this.getParseUntilAdv("\""));
        }
        this.parseZeroOrMoreWs();
        this.parseQualifierBlock(cl);
        return cl;
    }

    private void parseQualifierBlock(Clause cl) {
        if (this.stream.consume("{")) {
            this.parseZeroOrMoreQuals(cl);
            this.parseZeroOrMoreWs();
            boolean success = this.stream.consume("}");
            if (!success) {
                this.error("Missing closing '}' for trailing qualifier block.");
            }
        }
    }

    private void parseZeroOrMoreQuals(Clause cl) {
        if (this.parseQual(cl)) {
            while (this.stream.consume(",") && this.parseQual(cl)) {
            }
        }
    }

    private boolean parseQual(Clause cl) {
        String v;
        this.parseZeroOrMoreWs();
        String rest = this.stream.rest();
        if (!rest.contains("=")) {
            this.error("Missing '=' in trailing qualifier block. This might happen for not properly escaped '{', '}' chars in comments.");
        }
        String q = this.getParseUntilAdv("=");
        this.parseZeroOrMoreWs();
        if (this.stream.consume("\"")) {
            v = this.getParseUntilAdv("\"");
        } else {
            v = this.getParseUntil(" ,}");
            this.warn("qualifier values should be enclosed in quotes. You have: " + q + '=' + this.stream.rest());
        }
        if (v.isEmpty()) {
            this.warn("Empty value for qualifier in trailing qualifier block.");
            v = "";
        }
        QualifierValue qv = new QualifierValue(q, v);
        cl.addQualifierValue(qv);
        this.parseZeroOrMoreWs();
        return true;
    }

    private Clause parseBoolean(Clause cl) {
        if (this.stream.consume("true")) {
            cl.setValue(Boolean.TRUE);
        } else if (this.stream.consume("false")) {
            cl.setValue(Boolean.FALSE);
        } else {
            this.error("Could not parse boolean value.");
        }
        return cl;
    }

    protected void parseIdLine(Frame f) {
        String t = this.getParseTag();
        OBOFormatConstants.OboFormatTag tag = OBOFormatConstants.getTag(t);
        if (tag != OBOFormatConstants.OboFormatTag.TAG_ID) {
            this.error("Expected id tag as first line in frame, but was: " + (Object)((Object)tag));
        }
        Clause cl = new Clause(t);
        f.addClause(cl);
        String id = this.getParseUntil(BRACE);
        if (id.isEmpty()) {
            this.error("Could not find an valid id, id is empty.");
        }
        cl.addValue(id);
        f.setId(id);
        this.parseEOL(cl);
    }

    public void parseEOL(Clause cl) {
        this.parseQualifierAndHiddenComment(cl);
        this.forceParseNlOrEof();
    }

    private void parseHiddenComment() {
        this.parseZeroOrMoreWs();
        if (this.stream.peekCharIs('!')) {
            this.stream.forceEol();
        }
    }

    protected Clause parseUnquotedString(Clause cl) {
        this.parseZeroOrMoreWs();
        String v = this.getParseUntil("!{");
        v = OBOFormatParser.removeTrailingWS(v);
        cl.setValue(v);
        if (this.stream.peekCharIs('{')) {
            this.parseQualifierBlock(cl);
        }
        this.parseHiddenComment();
        return cl;
    }

    protected Clause parseCustomTag(Clause cl) {
        return this.parseUnquotedString(cl);
    }

    protected void forceParseNlOrEof() {
        this.parseZeroOrMoreWs();
        if (this.stream.eol()) {
            this.stream.advanceLine();
            return;
        }
        if (this.stream.eof()) {
            return;
        }
        this.error("expected newline or end of line but found: " + this.stream.rest());
    }

    protected void parseZeroOrMoreWsOptCmtNl() {
        while (true) {
            this.parseZeroOrMoreWs();
            this.parseHiddenComment();
            if (!this.stream.eol()) break;
            this.stream.advanceLine();
        }
    }

    protected void parseWs() {
        if (this.stream.eol()) {
            this.error("Expected at least one white space, but found end of line at pos: " + this.stream.pos);
        }
        if (this.stream.eof()) {
            this.error("Expected at least one white space, but found end of file.");
        }
        if (this.stream.peekChar() == ' ') {
            this.stream.advance(1);
        } else {
            this.warn("Expected white space at pos: " + this.stream.pos);
        }
    }

    protected void parseOneOrMoreWs() {
        if (this.stream.eol() || this.stream.eof()) {
            this.error("Expected at least one white space at pos: " + this.stream.pos);
        }
        int n = 0;
        while (this.stream.peekCharIs(' ')) {
            this.stream.advance(1);
            ++n;
        }
        if (n == 0) {
            this.error("Expected at least one white space at pos: " + this.stream.pos);
        }
    }

    protected void parseZeroOrMoreWs() {
        if (!this.stream.eol() && !this.stream.eof()) {
            while (this.stream.peekCharIs(' ')) {
                this.stream.advance(1);
            }
        }
    }

    private String getParseUntilAdv(String compl) {
        String ret = this.getParseUntil(compl);
        this.stream.advance(1);
        return ret;
    }

    private String getParseUntil(String compl) {
        return this.getParseUntil(compl, false);
    }

    private String getParseUntil(String compl, boolean commaWhitespace) {
        String r = this.stream.rest();
        int i = 0;
        boolean hasEscapedChars = false;
        while (i < r.length()) {
            if (r.charAt(i) == '\\') {
                hasEscapedChars = true;
                i += 2;
                continue;
            }
            if (compl.contains(r.subSequence(i, i + 1)) && (!commaWhitespace || r.charAt(i) != ',' || i + 1 < r.length() && r.charAt(i + 1) == ' ')) break;
            ++i;
        }
        if (i == 0) {
            return "";
        }
        String ret = r.substring(0, i);
        if (hasEscapedChars) {
            ret = this.handleEscapedChars(ret);
        }
        this.stream.advance(i);
        return (String)this.stringCache.get((Object)ret);
    }

    protected String handleEscapedChars(String ret) {
        StringBuilder sb = new StringBuilder();
        for (int j = 0; j < ret.length(); ++j) {
            char c = ret.charAt(j);
            if (c == '\\') {
                int next = j + 1;
                if (next >= ret.length()) continue;
                char nextChar = ret.charAt(next);
                this.handleNextChar(sb, nextChar);
                ++j;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    protected void handleNextChar(StringBuilder sb, char nextChar) {
        switch (nextChar) {
            case 'n': {
                sb.append('\n');
                break;
            }
            case 'W': {
                sb.append(' ');
                break;
            }
            case 't': {
                sb.append('\t');
                break;
            }
            default: {
                sb.append(nextChar);
            }
        }
    }

    private void error(String message) {
        throw new OBOFormatParserException(message, this.stream.lineNo, this.stream.line);
    }

    private void warn(String message) {
        LOG.warn("LINE: {} {}  LINE:\n{}", new Object[]{this.stream.lineNo, message, this.stream.line});
    }

    protected static class MyStream {
        int pos = 0;
        @Nullable
        String line;
        int lineNo = 0;
        @Nullable
        BufferedReader reader;

        public MyStream() {
            this.pos = 0;
        }

        public MyStream(BufferedReader r) {
            this.reader = r;
        }

        public static String getTag() {
            return "";
        }

        protected String line() {
            return (String)OWLAPIPreconditions.verifyNotNull((Object)this.line);
        }

        protected char peekChar() {
            this.prepare();
            return this.line().charAt(this.pos);
        }

        public char nextChar() {
            ++this.pos;
            return this.line().charAt(this.pos - 1);
        }

        public String rest() {
            this.prepare();
            if (this.line == null) {
                return "";
            }
            if (this.pos >= this.line().length()) {
                return "";
            }
            return this.line().substring(this.pos);
        }

        public void advance(int dist) {
            this.pos += dist;
        }

        public void prepare() {
            if (this.line == null) {
                this.advanceLine();
            }
        }

        public void advanceLine() {
            try {
                this.line = ((BufferedReader)OWLAPIPreconditions.verifyNotNull((Object)this.reader, (String)"reader must be set before accessing it")).readLine();
                ++this.lineNo;
                this.pos = 0;
            }
            catch (IOException e) {
                throw new OBOFormatParserException(e, this.lineNo, "Error reading from input.");
            }
        }

        public void forceEol() {
            if (this.line == null) {
                return;
            }
            this.pos = this.line().length();
        }

        public boolean eol() {
            this.prepare();
            if (this.line == null) {
                return false;
            }
            return this.pos >= this.line().length();
        }

        public boolean eof() {
            this.prepare();
            return this.line == null;
        }

        public boolean consume(String s) {
            String r = this.rest();
            if (r.isEmpty()) {
                return false;
            }
            if (r.startsWith(s)) {
                this.pos += s.length();
                return true;
            }
            return false;
        }

        public int indexOf(char c) {
            this.prepare();
            if (this.line == null) {
                return -1;
            }
            return this.line().substring(this.pos).indexOf(c);
        }

        public String toString() {
            return this.line + "//" + this.pos + " LINE:" + this.lineNo;
        }

        public boolean peekCharIs(char c) {
            if (this.eol() || this.eof()) {
                return false;
            }
            return this.peekChar() == c;
        }

        public int getLineNo() {
            return this.lineNo;
        }
    }
}

