/*
 * Decompiled with CFR 0.152.
 */
package biweekly.property;

import biweekly.ICalVersion;
import biweekly.Messages;
import biweekly.ValidationWarning;
import biweekly.component.ICalComponent;
import biweekly.property.ICalProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListProperty<T>
extends ICalProperty {
    protected final List<T> values;

    public ListProperty() {
        this.values = new ArrayList<T>();
    }

    public ListProperty(T ... values) {
        this.values = new ArrayList<T>(Arrays.asList(values));
    }

    public ListProperty(List<T> values) {
        if (values == null) {
            throw new NullPointerException(Messages.INSTANCE.getExceptionMessage(18, new Object[0]));
        }
        this.values = values;
    }

    public ListProperty(ListProperty<T> original) {
        super(original);
        this.values = new ArrayList<T>(original.values);
    }

    public List<T> getValues() {
        return this.values;
    }

    @Override
    protected void validate(List<ICalComponent> components, ICalVersion version, List<ValidationWarning> warnings) {
        if (this.values.isEmpty()) {
            warnings.add(new ValidationWarning(26, new Object[0]));
        }
    }

    @Override
    protected Map<String, Object> toStringValues() {
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        values.put("values", this.values);
        return values;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.values.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ListProperty other = (ListProperty)obj;
        return this.values.equals(other.values);
    }
}

