/*
 * Decompiled with CFR 0.152.
 */
package biweekly.property;

import biweekly.ICalVersion;
import biweekly.Messages;
import biweekly.ValidationWarning;
import biweekly.component.ICalComponent;
import biweekly.parameter.ICalParameters;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ICalProperty {
    protected ICalParameters parameters;

    public ICalProperty() {
        this.parameters = new ICalParameters();
    }

    protected ICalProperty(ICalProperty original) {
        this.parameters = new ICalParameters(original.parameters);
    }

    public ICalParameters getParameters() {
        return this.parameters;
    }

    public void setParameters(ICalParameters parameters) {
        if (parameters == null) {
            throw new NullPointerException(Messages.INSTANCE.getExceptionMessage(16, new Object[0]));
        }
        this.parameters = parameters;
    }

    public String getParameter(String name) {
        return (String)this.parameters.first(name);
    }

    public List<String> getParameters(String name) {
        return Collections.unmodifiableList(this.parameters.get(name));
    }

    public void addParameter(String name, String value) {
        this.parameters.put(name, value);
    }

    public void setParameter(String name, String value) {
        this.parameters.replace(name, value);
    }

    public void setParameter(String name, Collection<String> values) {
        this.parameters.replace(name, values);
    }

    public void removeParameter(String name) {
        this.parameters.removeAll(name);
    }

    String getAltRepresentation() {
        return this.parameters.getAltRepresentation();
    }

    void setAltRepresentation(String uri) {
        this.parameters.setAltRepresentation(uri);
    }

    String getFormatType() {
        return this.parameters.getFormatType();
    }

    void setFormatType(String formatType) {
        this.parameters.setFormatType(formatType);
    }

    String getLabel() {
        return this.parameters.getLabel();
    }

    void setLabel(String label) {
        this.parameters.setLabel(label);
    }

    String getLanguage() {
        return this.parameters.getLanguage();
    }

    void setLanguage(String language) {
        this.parameters.setLanguage(language);
    }

    String getSentBy() {
        return this.parameters.getSentBy();
    }

    void setSentBy(String uri) {
        this.parameters.setSentBy(uri);
    }

    String getCommonName() {
        return this.parameters.getCommonName();
    }

    void setCommonName(String commonName) {
        this.parameters.setCommonName(commonName);
    }

    String getDirectoryEntry() {
        return this.parameters.getDirectoryEntry();
    }

    void setDirectoryEntry(String uri) {
        this.parameters.setDirectoryEntry(uri);
    }

    public final List<ValidationWarning> validate(List<ICalComponent> components, ICalVersion version) {
        ArrayList<ValidationWarning> warnings = new ArrayList<ValidationWarning>(0);
        this.validate(components, version, warnings);
        warnings.addAll(this.parameters.validate(version));
        return warnings;
    }

    protected void validate(List<ICalComponent> components, ICalVersion version, List<ValidationWarning> warnings) {
    }

    protected Map<String, Object> toStringValues() {
        return Collections.emptyMap();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append(" [ parameters=").append(this.parameters);
        for (Map.Entry<String, Object> field : this.toStringValues().entrySet()) {
            String fieldName = field.getKey();
            Object fieldValue = field.getValue();
            sb.append(" | ").append(fieldName).append('=').append(fieldValue);
        }
        sb.append(" ]");
        return sb.toString();
    }

    public ICalProperty copy() {
        Class<?> clazz = this.getClass();
        try {
            Constructor<?> copyConstructor = clazz.getConstructor(clazz);
            return (ICalProperty)copyConstructor.newInstance(this);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException(Messages.INSTANCE.getExceptionMessage(17, clazz.getName()), e);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.parameters.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ICalProperty other = (ICalProperty)obj;
        return this.parameters.equals(other.parameters);
    }
}

