/*
 * Decompiled with CFR 0.152.
 */
package biweekly.property;

import biweekly.ICalVersion;
import biweekly.ValidationWarning;
import biweekly.component.ICalComponent;
import biweekly.property.ICalProperty;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Geo
extends ICalProperty {
    private Double latitude;
    private Double longitude;

    public Geo(Double latitude, Double longitude) {
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public Geo(Geo original) {
        super(original);
        this.latitude = original.latitude;
        this.longitude = original.longitude;
    }

    public Double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(Double latitude) {
        this.latitude = latitude;
    }

    public Double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(Double longitude) {
        this.longitude = longitude;
    }

    public static double toDecimal(int degrees, int minutes, int seconds) {
        return (double)degrees + (double)minutes / 60.0 + (double)seconds / 3600.0;
    }

    @Override
    protected void validate(List<ICalComponent> components, ICalVersion version, List<ValidationWarning> warnings) {
        if (this.latitude == null) {
            warnings.add(new ValidationWarning(41, new Object[0]));
        }
        if (this.longitude == null) {
            warnings.add(new ValidationWarning(42, new Object[0]));
        }
    }

    @Override
    protected Map<String, Object> toStringValues() {
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        values.put("latitude", this.latitude);
        values.put("longitude", this.longitude);
        return values;
    }

    @Override
    public Geo copy() {
        return new Geo(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.latitude == null ? 0 : this.latitude.hashCode());
        result = 31 * result + (this.longitude == null ? 0 : this.longitude.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        Geo other = (Geo)obj;
        if (this.latitude == null ? other.latitude != null : !this.latitude.equals(other.latitude)) {
            return false;
        }
        return !(this.longitude == null ? other.longitude != null : !this.longitude.equals(other.longitude));
    }
}

