/*
 * Decompiled with CFR 0.152.
 */
package biweekly.property;

import biweekly.ICalVersion;
import biweekly.ValidationWarning;
import biweekly.component.ICalComponent;
import biweekly.property.ICalProperty;
import biweekly.util.ICalDate;
import biweekly.util.UtcOffset;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Daylight
extends ICalProperty {
    private boolean daylight;
    private UtcOffset offset;
    private ICalDate start;
    private ICalDate end;
    private String standardName;
    private String daylightName;

    public Daylight() {
        this.daylight = false;
    }

    public Daylight(boolean daylight, UtcOffset offset, ICalDate start, ICalDate end, String standardName, String daylightName) {
        this.daylight = daylight;
        this.offset = offset;
        this.start = start;
        this.end = end;
        this.standardName = standardName;
        this.daylightName = daylightName;
    }

    public Daylight(Daylight original) {
        super(original);
        this.daylight = original.daylight;
        this.offset = original.offset;
        this.start = original.start == null ? null : new ICalDate(original.start);
        this.end = original.end == null ? null : new ICalDate(original.end);
        this.standardName = original.standardName;
        this.daylightName = original.daylightName;
    }

    public boolean isDaylight() {
        return this.daylight;
    }

    public void setDaylight(boolean daylight) {
        this.daylight = daylight;
    }

    public UtcOffset getOffset() {
        return this.offset;
    }

    public void setOffset(UtcOffset offset) {
        this.offset = offset;
    }

    public ICalDate getStart() {
        return this.start;
    }

    public void setStart(ICalDate start) {
        this.start = start;
    }

    public ICalDate getEnd() {
        return this.end;
    }

    public void setEnd(ICalDate end) {
        this.end = end;
    }

    public String getStandardName() {
        return this.standardName;
    }

    public void setStandardName(String name) {
        this.standardName = name;
    }

    public String getDaylightName() {
        return this.daylightName;
    }

    public void setDaylightName(String name) {
        this.daylightName = name;
    }

    @Override
    protected void validate(List<ICalComponent> components, ICalVersion version, List<ValidationWarning> warnings) {
        if (this.daylight && (this.offset == null || this.start == null || this.end == null || this.standardName == null || this.daylightName == null)) {
            warnings.add(new ValidationWarning(43, new Object[0]));
        }
    }

    @Override
    protected Map<String, Object> toStringValues() {
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        values.put("daylight", this.daylight);
        values.put("offset", this.offset);
        values.put("start", this.start);
        values.put("end", this.end);
        values.put("standardName", this.standardName);
        values.put("daylightName", this.daylightName);
        return values;
    }

    @Override
    public Daylight copy() {
        return new Daylight(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.daylight ? 1231 : 1237);
        result = 31 * result + (this.daylightName == null ? 0 : this.daylightName.hashCode());
        result = 31 * result + (this.end == null ? 0 : this.end.hashCode());
        result = 31 * result + (this.offset == null ? 0 : this.offset.hashCode());
        result = 31 * result + (this.standardName == null ? 0 : this.standardName.hashCode());
        result = 31 * result + (this.start == null ? 0 : this.start.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        Daylight other = (Daylight)obj;
        if (this.daylight != other.daylight) {
            return false;
        }
        if (this.daylightName == null ? other.daylightName != null : !this.daylightName.equals(other.daylightName)) {
            return false;
        }
        if (this.end == null ? other.end != null : !this.end.equals(other.end)) {
            return false;
        }
        if (this.offset == null ? other.offset != null : !this.offset.equals(other.offset)) {
            return false;
        }
        if (this.standardName == null ? other.standardName != null : !this.standardName.equals(other.standardName)) {
            return false;
        }
        return !(this.start == null ? other.start != null : !this.start.equals(other.start));
    }
}

