/*
 * Decompiled with CFR 0.152.
 */
package biweekly.property;

import biweekly.ICalVersion;
import biweekly.ValidationWarning;
import biweekly.component.ICalComponent;
import biweekly.property.ICalProperty;
import biweekly.util.Gobble;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryProperty
extends ICalProperty {
    protected byte[] data;
    protected String uri;

    public BinaryProperty(File file) throws IOException {
        this.data = new Gobble(file).asByteArray();
    }

    public BinaryProperty(byte[] data) {
        this.data = data;
    }

    public BinaryProperty(String uri) {
        this.uri = uri;
    }

    public BinaryProperty(BinaryProperty original) {
        super(original);
        this.data = original.data == null ? null : (byte[])original.data.clone();
        this.uri = original.uri;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
        this.uri = null;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
        this.data = null;
    }

    @Override
    public String getFormatType() {
        return super.getFormatType();
    }

    @Override
    public void setFormatType(String formatType) {
        super.setFormatType(formatType);
    }

    @Override
    protected void validate(List<ICalComponent> components, ICalVersion version, List<ValidationWarning> warnings) {
        if (this.uri == null && this.data == null) {
            warnings.add(new ValidationWarning(26, new Object[0]));
        }
    }

    @Override
    protected Map<String, Object> toStringValues() {
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        values.put("data", this.data == null ? "null" : "length: " + this.data.length);
        values.put("uri", this.uri);
        return values;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.data);
        result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        BinaryProperty other = (BinaryProperty)obj;
        if (this.uri == null ? other.uri != null : !this.uri.equals(other.uri)) {
            return false;
        }
        return Arrays.equals(this.data, other.data);
    }
}

