/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.xml;

import biweekly.ICalVersion;
import biweekly.ICalendar;
import biweekly.component.ICalComponent;
import biweekly.io.CannotParseException;
import biweekly.io.ParseContext;
import biweekly.io.ParseWarning;
import biweekly.io.SkipMeException;
import biweekly.io.StreamReader;
import biweekly.io.scribe.component.ICalComponentScribe;
import biweekly.io.scribe.property.ICalPropertyScribe;
import biweekly.io.xml.XCalQNames;
import biweekly.parameter.ICalParameters;
import biweekly.property.ICalProperty;
import biweekly.property.Version;
import biweekly.property.Xml;
import biweekly.util.XmlUtils;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import javax.xml.namespace.QName;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XCalReader
extends StreamReader {
    private final Source source;
    private final Closeable stream;
    private volatile ICalendar readICal;
    private volatile TransformerException thrown;
    private final ReadThread thread = new ReadThread();
    private final Object lock = new Object();
    private final BlockingQueue<Object> readerBlock = new ArrayBlockingQueue<Object>(1);
    private final BlockingQueue<Object> threadBlock = new ArrayBlockingQueue<Object>(1);

    public XCalReader(String str) {
        this(new StringReader(str));
    }

    public XCalReader(InputStream in) {
        this.source = new StreamSource(in);
        this.stream = in;
    }

    public XCalReader(File file) throws FileNotFoundException {
        this(new BufferedInputStream(new FileInputStream(file)));
    }

    public XCalReader(Reader reader) {
        this.source = new StreamSource(reader);
        this.stream = reader;
    }

    public XCalReader(Node node) {
        this.source = new DOMSource(node);
        this.stream = null;
    }

    protected ICalendar _readNext() throws IOException {
        this.readICal = null;
        this.warnings.clear();
        this.context = new ParseContext();
        this.thrown = null;
        if (!this.thread.started) {
            this.thread.start();
        } else {
            if (this.thread.finished || this.thread.closed) {
                return null;
            }
            try {
                this.threadBlock.put(this.lock);
            }
            catch (InterruptedException e) {
                return null;
            }
        }
        try {
            this.readerBlock.take();
        }
        catch (InterruptedException e) {
            return null;
        }
        if (this.thrown != null) {
            throw new IOException(this.thrown);
        }
        return this.readICal;
    }

    public void close() throws IOException {
        if (this.thread.isAlive()) {
            this.thread.closed = true;
            this.thread.interrupt();
        }
        if (this.stream != null) {
            this.stream.close();
        }
    }

    private static class NoOpErrorListener
    implements ErrorListener {
        private NoOpErrorListener() {
        }

        public void error(TransformerException e) {
        }

        public void fatalError(TransformerException e) {
        }

        public void warning(TransformerException e) {
        }
    }

    private static class XCalStructure {
        private final List<ElementType> stack = new ArrayList<ElementType>();

        private XCalStructure() {
        }

        public ElementType pop() {
            return this.isEmpty() ? null : this.stack.remove(this.stack.size() - 1);
        }

        public ElementType peek() {
            return this.isEmpty() ? null : this.stack.get(this.stack.size() - 1);
        }

        public void push(ElementType type) {
            this.stack.add(type);
        }

        public boolean isUnderParameters() {
            ElementType nonNull = null;
            for (int i = this.stack.size() - 1; i >= 0; --i) {
                ElementType type = this.stack.get(i);
                if (type == null) continue;
                nonNull = type;
                break;
            }
            return nonNull == ElementType.parameters || nonNull == ElementType.parameter || nonNull == ElementType.parameterValue;
        }

        public boolean isEmpty() {
            return this.stack.isEmpty();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ElementType {
        icalendar,
        components,
        properties,
        component,
        property,
        parameters,
        parameter,
        parameterValue;

    }

    private class ContentHandlerImpl
    extends DefaultHandler {
        private final Document DOC = XmlUtils.createDocument();
        private final XCalStructure structure = new XCalStructure();
        private final StringBuilder characterBuffer = new StringBuilder();
        private final LinkedList<ICalComponent> componentStack = new LinkedList();
        private Element propertyElement;
        private Element parent;
        private QName paramName;
        private ICalComponent curComponent;
        private ICalParameters parameters;

        private ContentHandlerImpl() {
        }

        public void characters(char[] buffer, int start, int length) throws SAXException {
            this.characterBuffer.append(buffer, start, length);
        }

        public void startElement(String namespace, String localName, String qName, Attributes attributes) throws SAXException {
            QName qname = new QName(namespace, localName);
            String textContent = this.emptyCharacterBuffer();
            if (this.structure.isEmpty()) {
                if (XCalQNames.ICALENDAR.equals(qname)) {
                    this.structure.push(ElementType.icalendar);
                }
                return;
            }
            ElementType parentType = this.structure.peek();
            ElementType typeToPush = null;
            if (parentType != null) {
                switch (parentType) {
                    case icalendar: {
                        ICalComponent component;
                        if (!XCalQNames.VCALENDAR.equals(qname)) break;
                        ICalComponentScribe<? extends ICalComponent> scribe = XCalReader.this.index.getComponentScribe(localName, ICalVersion.V2_0);
                        this.curComponent = component = scribe.emptyInstance();
                        XCalReader.this.readICal = (ICalendar)component;
                        typeToPush = ElementType.component;
                        break;
                    }
                    case component: {
                        if (XCalQNames.PROPERTIES.equals(qname)) {
                            typeToPush = ElementType.properties;
                            break;
                        }
                        if (!XCalQNames.COMPONENTS.equals(qname)) break;
                        this.componentStack.add(this.curComponent);
                        this.curComponent = null;
                        typeToPush = ElementType.components;
                        break;
                    }
                    case components: {
                        if (!"urn:ietf:params:xml:ns:icalendar-2.0".equals(namespace)) break;
                        ICalComponentScribe<? extends ICalComponent> scribe = XCalReader.this.index.getComponentScribe(localName, ICalVersion.V2_0);
                        this.curComponent = scribe.emptyInstance();
                        ICalComponent parent = this.componentStack.getLast();
                        parent.addComponent(this.curComponent);
                        typeToPush = ElementType.component;
                        break;
                    }
                    case properties: {
                        this.propertyElement = this.createElement(namespace, localName, attributes);
                        this.parameters = new ICalParameters();
                        this.parent = this.propertyElement;
                        typeToPush = ElementType.property;
                        break;
                    }
                    case property: {
                        if (!XCalQNames.PARAMETERS.equals(qname)) break;
                        typeToPush = ElementType.parameters;
                        break;
                    }
                    case parameters: {
                        if (!"urn:ietf:params:xml:ns:icalendar-2.0".equals(namespace)) break;
                        this.paramName = qname;
                        typeToPush = ElementType.parameter;
                        break;
                    }
                    case parameter: {
                        if (!"urn:ietf:params:xml:ns:icalendar-2.0".equals(namespace)) break;
                        typeToPush = ElementType.parameterValue;
                        break;
                    }
                }
            }
            if (this.propertyElement != null && typeToPush != ElementType.property && typeToPush != ElementType.parameters && !this.structure.isUnderParameters()) {
                if (textContent.length() > 0) {
                    this.parent.appendChild(this.DOC.createTextNode(textContent));
                }
                Element element = this.createElement(namespace, localName, attributes);
                this.parent.appendChild(element);
                this.parent = element;
            }
            this.structure.push(typeToPush);
        }

        public void endElement(String namespace, String localName, String qName) throws SAXException {
            String textContent = this.emptyCharacterBuffer();
            if (this.structure.isEmpty()) {
                return;
            }
            ElementType type = this.structure.pop();
            if (type == null && (this.propertyElement == null || this.structure.isUnderParameters())) {
                return;
            }
            if (type != null) {
                switch (type) {
                    case parameterValue: {
                        this.parameters.put(this.paramName.getLocalPart(), textContent);
                        break;
                    }
                    case parameter: {
                        break;
                    }
                    case parameters: {
                        break;
                    }
                    case property: {
                        XCalReader.this.context.getWarnings().clear();
                        XCalReader.this.context.setPropertyName(localName);
                        this.propertyElement.appendChild(this.DOC.createTextNode(textContent));
                        QName propertyQName = new QName(this.propertyElement.getNamespaceURI(), this.propertyElement.getLocalName());
                        ICalPropertyScribe<? extends ICalProperty> scribe = XCalReader.this.index.getPropertyScribe(propertyQName);
                        try {
                            Version versionProp;
                            ICalVersion version;
                            ICalProperty property = scribe.parseXml(this.propertyElement, this.parameters, XCalReader.this.context);
                            if (property instanceof Version && this.curComponent instanceof ICalendar && (version = (versionProp = (Version)property).toICalVersion()) != null) {
                                ICalendar ical = (ICalendar)this.curComponent;
                                ical.setVersion(version);
                                XCalReader.this.context.setVersion(version);
                                this.propertyElement = null;
                                break;
                            }
                            this.curComponent.addProperty(property);
                            XCalReader.this.warnings.addAll(XCalReader.this.context.getWarnings());
                        }
                        catch (SkipMeException e) {
                            XCalReader.this.warnings.add(new ParseWarning.Builder(XCalReader.this.context).message(0, e.getMessage()).build());
                        }
                        catch (CannotParseException e) {
                            XCalReader.this.warnings.add(new ParseWarning.Builder(XCalReader.this.context).message(e).build());
                            scribe = XCalReader.this.index.getPropertyScribe(Xml.class);
                            ICalProperty property = scribe.parseXml(this.propertyElement, this.parameters, XCalReader.this.context);
                            this.curComponent.addProperty(property);
                        }
                        this.propertyElement = null;
                        break;
                    }
                    case component: {
                        this.curComponent = null;
                        if (!XCalQNames.VCALENDAR.getNamespaceURI().equals(namespace) || !XCalQNames.VCALENDAR.getLocalPart().equals(localName)) break;
                        try {
                            XCalReader.this.readerBlock.put(XCalReader.this.lock);
                            XCalReader.this.threadBlock.take();
                        }
                        catch (InterruptedException e) {
                            throw new SAXException(e);
                        }
                        return;
                    }
                    case properties: {
                        break;
                    }
                    case components: {
                        this.curComponent = this.componentStack.removeLast();
                        break;
                    }
                }
            }
            if (this.propertyElement != null && type != ElementType.property && type != ElementType.parameters && !this.structure.isUnderParameters()) {
                if (textContent.length() > 0) {
                    this.parent.appendChild(this.DOC.createTextNode(textContent));
                }
                this.parent = (Element)this.parent.getParentNode();
            }
        }

        private String emptyCharacterBuffer() {
            String textContent = this.characterBuffer.toString();
            this.characterBuffer.setLength(0);
            return textContent;
        }

        private Element createElement(String namespace, String localName, Attributes attributes) {
            Element element = this.DOC.createElementNS(namespace, localName);
            this.applyAttributesTo(element, attributes);
            return element;
        }

        private void applyAttributesTo(Element element, Attributes attributes) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                String qname = attributes.getQName(i);
                if (qname.startsWith("xmlns:")) continue;
                String name = attributes.getLocalName(i);
                String value = attributes.getValue(i);
                element.setAttribute(name, value);
            }
        }
    }

    private class ReadThread
    extends Thread {
        private final SAXResult result;
        private final Transformer transformer;
        private volatile boolean finished = false;
        private volatile boolean started = false;
        private volatile boolean closed = false;

        public ReadThread() {
            this.setName(this.getClass().getSimpleName());
            try {
                TransformerFactory factory = TransformerFactory.newInstance();
                XmlUtils.applyXXEProtection(factory);
                this.transformer = factory.newTransformer();
            }
            catch (TransformerConfigurationException e) {
                throw new RuntimeException(e);
            }
            this.transformer.setErrorListener(new NoOpErrorListener());
            this.result = new SAXResult(new ContentHandlerImpl());
        }

        public void run() {
            this.started = true;
            try {
                this.transformer.transform(XCalReader.this.source, this.result);
            }
            catch (TransformerException e) {
                if (!((XCalReader)XCalReader.this).thread.closed) {
                    XCalReader.this.thrown = e;
                }
            }
            finally {
                this.finished = true;
                try {
                    XCalReader.this.readerBlock.put(XCalReader.this.lock);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

