/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.scribe.property;

import biweekly.ICalDataType;
import biweekly.ICalVersion;
import biweekly.io.DataModelConversionException;
import biweekly.io.ParseContext;
import biweekly.io.WriteContext;
import biweekly.io.scribe.property.ICalPropertyScribe;
import biweekly.parameter.ICalParameters;
import biweekly.parameter.Role;
import biweekly.property.Attendee;
import biweekly.property.Organizer;
import java.util.EnumSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrganizerScribe
extends ICalPropertyScribe<Organizer> {
    public OrganizerScribe() {
        super(Organizer.class, "ORGANIZER", ICalDataType.CAL_ADDRESS);
    }

    @Override
    protected ICalParameters _prepareParameters(Organizer property, WriteContext context) {
        String name = property.getCommonName();
        if (name != null) {
            ICalParameters copy = new ICalParameters(property.getParameters());
            copy.put("CN", name);
            return copy;
        }
        return super._prepareParameters(property, context);
    }

    @Override
    protected Organizer _parseText(String value, ICalDataType dataType, ICalParameters parameters, ParseContext context) {
        String name = parameters.getCommonName();
        if (name != null) {
            parameters.remove("CN", name);
        }
        String uri = null;
        String email = null;
        int colon = value.indexOf(58);
        if (colon == 6) {
            String scheme = value.substring(0, colon);
            if (scheme.equalsIgnoreCase("mailto")) {
                email = value.substring(colon + 1);
            } else {
                uri = value;
            }
        } else {
            uri = value;
        }
        Organizer organizer = new Organizer(name, email);
        organizer.setUri(uri);
        return organizer;
    }

    @Override
    protected String _writeText(Organizer property, WriteContext context) {
        if (context.getVersion() == ICalVersion.V1_0) {
            Attendee attendee = new Attendee(property.getCommonName(), property.getEmail());
            attendee.setRole(Role.ORGANIZER);
            attendee.setUri(property.getUri());
            attendee.setParameters(property.getParameters());
            DataModelConversionException conversionException = new DataModelConversionException(property);
            conversionException.getProperties().add(attendee);
            throw conversionException;
        }
        String uri = property.getUri();
        if (uri != null) {
            return uri;
        }
        String email = property.getEmail();
        if (email != null) {
            return "mailto:" + email;
        }
        return "";
    }

    @Override
    public Set<ICalVersion> getSupportedVersions() {
        return EnumSet.of(ICalVersion.V2_0_DEPRECATED, ICalVersion.V2_0);
    }
}

