/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.json;

import biweekly.ICalDataType;
import biweekly.io.json.JCalParseException;
import biweekly.io.json.JCalValue;
import biweekly.io.json.JsonValue;
import biweekly.io.scribe.ScribeIndex;
import biweekly.parameter.ICalParameters;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCalRawReader
implements Closeable {
    private static final String VCALENDAR_COMPONENT_NAME = ScribeIndex.getICalendarScribe().getComponentName().toLowerCase();
    private final Reader reader;
    private JsonParser parser;
    private boolean eof = false;
    private JCalDataStreamListener listener;
    private boolean strict = false;

    public JCalRawReader(Reader reader) {
        this.reader = reader;
    }

    public JCalRawReader(JsonParser parser, boolean strict) {
        this.reader = null;
        this.parser = parser;
        this.strict = strict;
    }

    public int getLineNum() {
        return this.parser == null ? 0 : this.parser.getCurrentLocation().getLineNr();
    }

    public void readNext(JCalDataStreamListener listener) throws IOException {
        JsonToken cur;
        if (this.parser == null) {
            JsonFactory factory = new JsonFactory();
            this.parser = factory.createParser(this.reader);
        }
        if (this.parser.isClosed()) {
            return;
        }
        this.listener = listener;
        JsonToken prev = this.parser.getCurrentToken();
        while (!((cur = this.parser.nextToken()) == null || prev == JsonToken.START_ARRAY && cur == JsonToken.VALUE_STRING && VCALENDAR_COMPONENT_NAME.equals(this.parser.getValueAsString()))) {
            if (this.strict) {
                if (prev != JsonToken.START_ARRAY) {
                    throw new JCalParseException(JsonToken.START_ARRAY, prev);
                }
                if (cur != JsonToken.VALUE_STRING) {
                    throw new JCalParseException(JsonToken.VALUE_STRING, cur);
                }
                throw new JCalParseException("Invalid value for first token: expected \"vcalendar\" , was \"" + this.parser.getValueAsString() + "\"", JsonToken.VALUE_STRING, cur);
            }
            prev = cur;
        }
        if (cur == null) {
            this.eof = true;
            return;
        }
        this.parseComponent(new ArrayList<String>());
    }

    private void parseComponent(List<String> components) throws IOException {
        this.checkCurrent(JsonToken.VALUE_STRING);
        String componentName = this.parser.getValueAsString();
        this.listener.readComponent(components, componentName);
        components.add(componentName);
        this.checkNext(JsonToken.START_ARRAY);
        while (this.parser.nextToken() != JsonToken.END_ARRAY) {
            this.checkCurrent(JsonToken.START_ARRAY);
            this.parser.nextToken();
            this.parseProperty(components);
        }
        this.checkNext(JsonToken.START_ARRAY);
        while (this.parser.nextToken() != JsonToken.END_ARRAY) {
            this.checkCurrent(JsonToken.START_ARRAY);
            this.parser.nextToken();
            this.parseComponent(new ArrayList<String>(components));
        }
        this.checkNext(JsonToken.END_ARRAY);
    }

    private void parseProperty(List<String> components) throws IOException {
        this.checkCurrent(JsonToken.VALUE_STRING);
        String propertyName = this.parser.getValueAsString().toLowerCase();
        ICalParameters parameters = this.parseParameters();
        this.checkNext(JsonToken.VALUE_STRING);
        String dataTypeStr = this.parser.getText();
        ICalDataType dataType = "unknown".equals(dataTypeStr) ? null : ICalDataType.get(dataTypeStr);
        List<JsonValue> values = this.parseValues();
        JCalValue value = new JCalValue(values);
        this.listener.readProperty(components, propertyName, parameters, dataType, value);
    }

    private ICalParameters parseParameters() throws IOException {
        this.checkNext(JsonToken.START_OBJECT);
        ICalParameters parameters = new ICalParameters();
        while (this.parser.nextToken() != JsonToken.END_OBJECT) {
            String parameterName = this.parser.getText();
            if (this.parser.nextToken() == JsonToken.START_ARRAY) {
                while (this.parser.nextToken() != JsonToken.END_ARRAY) {
                    parameters.put(parameterName, this.parser.getText());
                }
                continue;
            }
            parameters.put(parameterName, this.parser.getValueAsString());
        }
        return parameters;
    }

    private List<JsonValue> parseValues() throws IOException {
        ArrayList<JsonValue> values = new ArrayList<JsonValue>();
        while (this.parser.nextToken() != JsonToken.END_ARRAY) {
            JsonValue value = this.parseValue();
            values.add(value);
        }
        return values;
    }

    private Object parseValueElement() throws IOException {
        switch (this.parser.getCurrentToken()) {
            case VALUE_FALSE: 
            case VALUE_TRUE: {
                return this.parser.getBooleanValue();
            }
            case VALUE_NUMBER_FLOAT: {
                return this.parser.getDoubleValue();
            }
            case VALUE_NUMBER_INT: {
                return this.parser.getLongValue();
            }
            case VALUE_NULL: {
                return null;
            }
        }
        return this.parser.getText();
    }

    private List<JsonValue> parseValueArray() throws IOException {
        ArrayList<JsonValue> array = new ArrayList<JsonValue>();
        while (this.parser.nextToken() != JsonToken.END_ARRAY) {
            JsonValue value = this.parseValue();
            array.add(value);
        }
        return array;
    }

    private Map<String, JsonValue> parseValueObject() throws IOException {
        HashMap<String, JsonValue> object = new HashMap<String, JsonValue>();
        this.parser.nextToken();
        while (this.parser.getCurrentToken() != JsonToken.END_OBJECT) {
            this.checkCurrent(JsonToken.FIELD_NAME);
            String key = this.parser.getText();
            this.parser.nextToken();
            JsonValue value = this.parseValue();
            object.put(key, value);
            this.parser.nextToken();
        }
        return object;
    }

    private JsonValue parseValue() throws IOException {
        switch (this.parser.getCurrentToken()) {
            case START_ARRAY: {
                return new JsonValue(this.parseValueArray());
            }
            case START_OBJECT: {
                return new JsonValue(this.parseValueObject());
            }
        }
        return new JsonValue(this.parseValueElement());
    }

    private void checkNext(JsonToken expected) throws IOException {
        JsonToken actual = this.parser.nextToken();
        this.check(expected, actual);
    }

    private void checkCurrent(JsonToken expected) throws JCalParseException {
        JsonToken actual = this.parser.getCurrentToken();
        this.check(expected, actual);
    }

    private void check(JsonToken expected, JsonToken actual) throws JCalParseException {
        if (actual != expected) {
            throw new JCalParseException(expected, actual);
        }
    }

    public boolean eof() {
        return this.eof;
    }

    @Override
    public void close() throws IOException {
        if (this.parser != null) {
            this.parser.close();
        }
        if (this.reader != null) {
            this.reader.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface JCalDataStreamListener {
        public void readComponent(List<String> var1, String var2);

        public void readProperty(List<String> var1, String var2, ICalParameters var3, ICalDataType var4, JCalValue var5);
    }
}

