/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io;

import biweekly.Messages;
import biweekly.component.DaylightSavingsTime;
import biweekly.component.Observance;
import biweekly.component.StandardTime;
import biweekly.component.VTimezone;
import biweekly.property.ExceptionDates;
import biweekly.property.ExceptionRule;
import biweekly.property.RecurrenceDates;
import biweekly.property.RecurrenceRule;
import biweekly.property.TimezoneName;
import biweekly.property.ValuedProperty;
import biweekly.util.Google2445Utils;
import biweekly.util.ICalDate;
import biweekly.util.Recurrence;
import biweekly.util.UtcOffset;
import biweekly.util.com.google.ical.iter.RecurrenceIterator;
import biweekly.util.com.google.ical.iter.RecurrenceIteratorFactory;
import biweekly.util.com.google.ical.util.DTBuilder;
import biweekly.util.com.google.ical.values.DateTimeValue;
import biweekly.util.com.google.ical.values.DateTimeValueImpl;
import biweekly.util.com.google.ical.values.DateValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ICalTimeZone
extends TimeZone {
    private final VTimezone component;
    private final Map<Observance, List<DateValue>> observanceDateCache;
    final List<Observance> sortedObservances;
    private final int rawOffset;
    private final TimeZone utc = TimeZone.getTimeZone("UTC");
    private final Calendar utcCalendar = Calendar.getInstance(this.utc);

    public ICalTimeZone(VTimezone component) {
        this.component = component;
        int numObservances = component.getStandardTimes().size() + component.getDaylightSavingsTime().size();
        this.observanceDateCache = new IdentityHashMap<Observance, List<DateValue>>(numObservances);
        this.sortedObservances = this.calculateSortedObservances();
        this.rawOffset = this.calculateRawOffset();
        String id = ValuedProperty.getValue(component.getTimezoneId());
        if (id != null) {
            this.setID(id);
        }
    }

    private List<Observance> calculateSortedObservances() {
        List<DaylightSavingsTime> daylights = this.component.getDaylightSavingsTime();
        List<StandardTime> standards = this.component.getStandardTimes();
        int numObservances = standards.size() + daylights.size();
        ArrayList<Observance> sortedObservances = new ArrayList<Observance>(numObservances);
        sortedObservances.addAll(standards);
        sortedObservances.addAll(daylights);
        Collections.sort(sortedObservances, new Comparator<Observance>(){

            @Override
            public int compare(Observance left, Observance right) {
                ICalDate startLeft = ValuedProperty.getValue(left.getDateStart());
                ICalDate startRight = ValuedProperty.getValue(right.getDateStart());
                if (startLeft == null && startRight == null) {
                    return 0;
                }
                if (startLeft == null) {
                    return -1;
                }
                if (startRight == null) {
                    return 1;
                }
                return startLeft.getRawComponents().compareTo(startRight.getRawComponents());
            }
        });
        return Collections.unmodifiableList(sortedObservances);
    }

    @Override
    public String getDisplayName(boolean daylight, int style, Locale locale) {
        ListIterator<Observance> it = this.sortedObservances.listIterator(this.sortedObservances.size());
        while (it.hasPrevious()) {
            String name;
            List<TimezoneName> names;
            Observance observance = it.previous();
            if (daylight && observance instanceof DaylightSavingsTime && !(names = observance.getTimezoneNames()).isEmpty() && (name = (String)names.get(0).getValue()) != null) {
                return name;
            }
            if (daylight || !(observance instanceof StandardTime) || (names = observance.getTimezoneNames()).isEmpty() || (name = (String)names.get(0).getValue()) == null) continue;
            return name;
        }
        return super.getDisplayName(daylight, style, locale);
    }

    @Override
    public int getOffset(int era, int year, int month, int day, int dayOfWeek, int millis) {
        int hour = millis / 1000 / 60 / 60;
        millis -= hour * 1000 * 60 * 60;
        int minute = millis / 1000 / 60;
        int second = (millis -= minute * 1000 * 60) / 1000;
        Observance observance = this.getObservance(year, month + 1, day, hour, minute, second);
        if (observance == null) {
            for (Observance obs : this.sortedObservances) {
                UtcOffset offsetFrom;
                ICalDate dateStart = ValuedProperty.getValue(obs.getDateStart());
                if (dateStart == null || (offsetFrom = ValuedProperty.getValue(obs.getTimezoneOffsetFrom())) == null) continue;
                return (int)offsetFrom.getMillis();
            }
            return 0;
        }
        UtcOffset offsetTo = ValuedProperty.getValue(observance.getTimezoneOffsetTo());
        return offsetTo == null ? 0 : (int)offsetTo.getMillis();
    }

    @Override
    public int getRawOffset() {
        return this.rawOffset;
    }

    private int calculateRawOffset() {
        Observance observance = this.getObservance(new Date());
        if (observance == null) {
            for (Observance obs : this.sortedObservances) {
                UtcOffset offsetTo;
                if (!(obs instanceof StandardTime) || (offsetTo = ValuedProperty.getValue(obs.getTimezoneOffsetTo())) == null) continue;
                return (int)offsetTo.getMillis();
            }
            return 0;
        }
        UtcOffset offset = ValuedProperty.getValue(observance instanceof StandardTime ? observance.getTimezoneOffsetTo() : observance.getTimezoneOffsetFrom());
        return offset == null ? 0 : (int)offset.getMillis();
    }

    @Override
    public boolean inDaylightTime(Date date) {
        if (!this.useDaylightTime()) {
            return false;
        }
        Observance observance = this.getObservance(date);
        return observance == null ? false : observance instanceof DaylightSavingsTime;
    }

    @Override
    public void setRawOffset(int offset) {
        throw new UnsupportedOperationException(Messages.INSTANCE.getExceptionMessage(12, new Object[0]));
    }

    @Override
    public boolean useDaylightTime() {
        for (Observance observance : this.sortedObservances) {
            if (!(observance instanceof DaylightSavingsTime)) continue;
            return true;
        }
        return false;
    }

    public Boundary getObservanceBoundary(Date date) {
        this.utcCalendar.setTime(date);
        int year = this.utcCalendar.get(1);
        int month = this.utcCalendar.get(2) + 1;
        int day = this.utcCalendar.get(5);
        int hour = this.utcCalendar.get(10);
        int minute = this.utcCalendar.get(12);
        int second = this.utcCalendar.get(13);
        return this.getObservanceBoundary(year, month, day, hour, minute, second);
    }

    public Observance getObservance(Date date) {
        Boundary boundary = this.getObservanceBoundary(date);
        return boundary == null ? null : boundary.getObservanceIn();
    }

    public VTimezone getComponent() {
        return this.component;
    }

    private Observance getObservance(int year, int month, int day, int hour, int minute, int second) {
        Boundary boundary = this.getObservanceBoundary(year, month, day, hour, minute, second);
        return boundary == null ? null : boundary.getObservanceIn();
    }

    private Boundary getObservanceBoundary(int year, int month, int day, int hour, int minute, int second) {
        if (this.sortedObservances.isEmpty()) {
            return null;
        }
        DateTimeValueImpl givenTime = new DateTimeValueImpl(year, month, day, hour, minute, second);
        int closestIndex = -1;
        Observance closest = null;
        DateValue closestValue = null;
        for (int i = 0; i < this.sortedObservances.size(); ++i) {
            DateValue dateValue;
            DateValue dtstartValue;
            Observance observance = this.sortedObservances.get(i);
            ICalDate dtstart = ValuedProperty.getValue(observance.getDateStart());
            if (dtstart != null && (dtstartValue = Google2445Utils.convertFromRawComponents(dtstart)).compareTo(givenTime) > 0 || (dateValue = this.getObservanceDateClosestToTheGivenDate(observance, givenTime, false)) == null || closestValue != null && closestValue.compareTo(dateValue) >= 0) continue;
            closestValue = dateValue;
            closest = observance;
            closestIndex = i;
        }
        Observance observanceIn = closest;
        DateValue observanceInStart = closestValue;
        Observance observanceAfter = null;
        DateValue observanceAfterStart = null;
        if (closestIndex < this.sortedObservances.size() - 1) {
            observanceAfter = this.sortedObservances.get(closestIndex + 1);
            observanceAfterStart = this.getObservanceDateClosestToTheGivenDate(observanceAfter, givenTime, true);
        }
        if (observanceInStart != null && !(observanceInStart instanceof DateTimeValue)) {
            observanceInStart = new DTBuilder(observanceInStart).toDateTime();
        }
        if (observanceAfterStart != null && !(observanceAfterStart instanceof DateTimeValue)) {
            observanceAfterStart = new DTBuilder(observanceAfterStart).toDateTime();
        }
        return new Boundary((DateTimeValue)observanceInStart, observanceIn, (DateTimeValue)observanceAfterStart, observanceAfter);
    }

    private DateValue getObservanceDateClosestToTheGivenDate(Observance observance, DateValue givenDate, boolean after) {
        List<DateValue> dateCache = this.observanceDateCache.get(observance);
        if (dateCache == null) {
            dateCache = new ArrayList<DateValue>();
            this.observanceDateCache.put(observance, dateCache);
        }
        if (dateCache.isEmpty()) {
            DateValue prev = null;
            DateValue cur = null;
            boolean stopped = false;
            RecurrenceIterator it = this.createIterator(observance);
            while (it.hasNext()) {
                cur = it.next();
                dateCache.add(cur);
                if (givenDate.compareTo(cur) < 0) {
                    stopped = true;
                    break;
                }
                prev = cur;
            }
            return after ? (stopped ? cur : null) : prev;
        }
        DateValue last = dateCache.get(dateCache.size() - 1);
        int comparison = last.compareTo(givenDate);
        if (after && comparison <= 0 || comparison < 0) {
            RecurrenceIterator it = this.createIterator(observance);
            it.advanceTo(last);
            DateValue prev = null;
            DateValue cur = null;
            boolean stopped = false;
            while (it.hasNext()) {
                cur = it.next();
                dateCache.add(cur);
                if (givenDate.compareTo(cur) < 0) {
                    stopped = true;
                    break;
                }
                prev = cur;
            }
            return after ? (stopped ? cur : null) : prev;
        }
        int index = Collections.binarySearch(dateCache, givenDate);
        if (index < 0) {
            index = index * -1 - 1;
            if (after) {
                int afterIndex = index;
                return afterIndex < dateCache.size() ? dateCache.get(afterIndex) : null;
            }
            int beforeIndex = index - 1;
            if (beforeIndex < 0) {
                return null;
            }
            if (beforeIndex >= dateCache.size()) {
                return dateCache.get(dateCache.size() - 1);
            }
            return dateCache.get(beforeIndex);
        }
        if (after) {
            int afterIndex = index + 1;
            return afterIndex < dateCache.size() ? dateCache.get(afterIndex) : null;
        }
        return dateCache.get(index);
    }

    RecurrenceIterator createIterator(Observance observance) {
        ArrayList<RecurrenceIterator> inclusions = new ArrayList<RecurrenceIterator>();
        ArrayList<RecurrenceIterator> exclusions = new ArrayList<RecurrenceIterator>();
        ICalDate dtstart = ValuedProperty.getValue(observance.getDateStart());
        if (dtstart != null) {
            Recurrence recur;
            DateValue dtstartValue = Google2445Utils.convertFromRawComponents(dtstart);
            inclusions.add(new DateValueRecurrenceIterator(Arrays.asList(dtstartValue)));
            for (RecurrenceRule recurrenceRule : observance.getProperties(RecurrenceRule.class)) {
                recur = (Recurrence)recurrenceRule.getValue();
                if (recur == null) continue;
                inclusions.add(RecurrenceIteratorFactory.createRecurrenceIterator(recur, dtstartValue, this.utc));
            }
            for (ExceptionRule exceptionRule : observance.getProperties(ExceptionRule.class)) {
                recur = (Recurrence)exceptionRule.getValue();
                if (recur == null) continue;
                exclusions.add(RecurrenceIteratorFactory.createRecurrenceIterator(recur, dtstartValue, this.utc));
            }
        }
        ArrayList<ICalDate> rdates = new ArrayList<ICalDate>();
        for (RecurrenceDates recurrenceDates : observance.getRecurrenceDates()) {
            rdates.addAll(recurrenceDates.getDates());
        }
        Collections.sort(rdates);
        inclusions.add(new DateRecurrenceIterator(rdates));
        ArrayList<ICalDate> exdates = new ArrayList<ICalDate>();
        for (ExceptionDates exdate : observance.getProperties(ExceptionDates.class)) {
            exdates.addAll(exdate.getValues());
        }
        Collections.sort(exdates);
        exclusions.add(new DateRecurrenceIterator(exdates));
        RecurrenceIterator recurrenceIterator = ICalTimeZone.join(inclusions);
        if (exclusions.isEmpty()) {
            return recurrenceIterator;
        }
        RecurrenceIterator excluded = ICalTimeZone.join(exclusions);
        return RecurrenceIteratorFactory.except(recurrenceIterator, excluded);
    }

    private static RecurrenceIterator join(List<RecurrenceIterator> iterators) {
        if (iterators.isEmpty()) {
            return new EmptyRecurrenceIterator();
        }
        RecurrenceIterator first = iterators.get(0);
        if (iterators.size() == 1) {
            return first;
        }
        List<RecurrenceIterator> theRest = iterators.subList(1, iterators.size());
        return RecurrenceIteratorFactory.join(first, theRest.toArray(new RecurrenceIterator[0]));
    }

    public static class Boundary {
        private final DateTimeValue observanceInStart;
        private final DateTimeValue observanceAfterStart;
        private final Observance observanceIn;
        private final Observance observanceAfter;

        public Boundary(DateTimeValue observanceInStart, Observance observanceIn, DateTimeValue observanceAfterStart, Observance observanceAfter) {
            this.observanceInStart = observanceInStart;
            this.observanceAfterStart = observanceAfterStart;
            this.observanceIn = observanceIn;
            this.observanceAfter = observanceAfter;
        }

        public DateTimeValue getObservanceInStart() {
            return this.observanceInStart;
        }

        public DateTimeValue getObservanceAfterStart() {
            return this.observanceAfterStart;
        }

        public Observance getObservanceIn() {
            return this.observanceIn;
        }

        public Observance getObservanceAfter() {
            return this.observanceAfter;
        }

        public String toString() {
            return "Boundary [observanceInStart=" + this.observanceInStart + ", observanceAfterStart=" + this.observanceAfterStart + ", observanceIn=" + this.observanceIn + ", observanceAfter=" + this.observanceAfter + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class IteratorWrapper<T>
    implements RecurrenceIterator {
        protected final Iterator<T> it;
        private DateValue next;

        public IteratorWrapper(Iterator<T> it) {
            this.it = it;
        }

        @Override
        public DateValue next() {
            if (this.next != null) {
                DateValue value = this.next;
                this.next = null;
                return value;
            }
            return this.toDateValue(this.it.next());
        }

        @Override
        public boolean hasNext() {
            return this.next != null || this.it.hasNext();
        }

        @Override
        public void advanceTo(DateValue newStartUtc) {
            if (this.next != null && this.next.compareTo(newStartUtc) >= 0) {
                return;
            }
            while (this.it.hasNext()) {
                DateValue next = this.toDateValue(this.it.next());
                if (next.compareTo(newStartUtc) < 0) continue;
                this.next = next;
                break;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        protected abstract DateValue toDateValue(T var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DateRecurrenceIterator
    extends IteratorWrapper<ICalDate> {
        public DateRecurrenceIterator(Collection<ICalDate> dates) {
            super(dates.iterator());
        }

        @Override
        protected DateValue toDateValue(ICalDate value) {
            return Google2445Utils.convertFromRawComponents(value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DateValueRecurrenceIterator
    extends IteratorWrapper<DateValue> {
        public DateValueRecurrenceIterator(Collection<DateValue> dates) {
            super(dates.iterator());
        }

        @Override
        protected DateValue toDateValue(DateValue value) {
            return value;
        }
    }

    private static class EmptyRecurrenceIterator
    implements RecurrenceIterator {
        private EmptyRecurrenceIterator() {
        }

        public boolean hasNext() {
            return false;
        }

        public DateValue next() {
            throw new NoSuchElementException();
        }

        public void advanceTo(DateValue newStartUtc) {
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

