/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.cli;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import org.apache.any23.cli.Tool;

abstract class BaseTool
implements Tool {
    BaseTool() {
    }

    abstract PrintStream getOut();

    abstract void setOut(PrintStream var1);

    void run(boolean concise) throws Exception {
        PrintStream out = BaseTool.concise(this.getOut(), concise);
        this.setOut(out);
        try {
            this.run();
        }
        finally {
            BaseTool.close(out);
        }
    }

    private static void close(PrintStream stream) {
        if (stream != null && stream != System.out && stream != System.err) {
            try {
                stream.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static PrintStream concise(PrintStream out, boolean concise) {
        try {
            return concise && (out == System.out || out == System.err) ? new ConcisePrintStream(out) : (out instanceof ConcisePrintStream ? ((ConcisePrintStream)out).out : out);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Error supporting UTF-8 encodings in ConcisePrintStream", e);
        }
    }

    private static final class ConcisePrintStream
    extends PrintStream {
        private PrintStream out;

        private ConcisePrintStream(final PrintStream out) throws UnsupportedEncodingException {
            super(new OutputStream(){
                StringBuilder sb = new StringBuilder();
                int lineCount;
                boolean truncated = false;

                @Override
                public void write(int b) throws IOException {
                    if (this.sb == null) {
                        throw new IOException("stream closed");
                    }
                    if (b == 10) {
                        ++this.lineCount;
                    }
                    if (this.lineCount == 0 && this.sb.length() < 200) {
                        this.sb.append((char)b);
                    } else if (!Character.isWhitespace(b)) {
                        this.truncated = true;
                    }
                }

                @Override
                public void close() {
                    if (this.sb == null) {
                        return;
                    }
                    if (this.truncated) {
                        this.sb.append("...");
                    }
                    if (this.lineCount > 1) {
                        this.sb.append("\n...\n[Suppressed ").append(this.lineCount).append(" lines of output.]");
                    }
                    out.println(this.sb);
                    this.sb = null;
                    BaseTool.close(out);
                }
            }, true, "UTF-8");
            this.out = out;
        }
    }
}

