/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.source;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.any23.source.DocumentSource;

public class StringDocumentSource
implements DocumentSource {
    private final String in;
    private final String contentType;
    private final String encoding;
    private final String uri;

    public StringDocumentSource(String in, String uri) {
        this(in, uri, null, null);
    }

    public StringDocumentSource(String in, String uri, String contentType) {
        this(in, uri, contentType, null);
    }

    public StringDocumentSource(String in, String uri, String contentType, String encoding) {
        this.in = in;
        this.uri = uri;
        this.contentType = contentType;
        this.encoding = encoding;
    }

    public InputStream openInputStream() throws IOException {
        if (this.encoding == null) {
            return new ByteArrayInputStream(this.in.getBytes(StandardCharsets.UTF_8));
        }
        return new ByteArrayInputStream(this.in.getBytes(this.encoding));
    }

    public long getContentLength() {
        return this.in.length();
    }

    public String getDocumentIRI() {
        return this.uri;
    }

    public String getContentType() {
        return this.contentType;
    }

    public boolean isLocal() {
        return true;
    }
}

