/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.source;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.any23.source.DocumentSource;

public class FileDocumentSource
implements DocumentSource {
    private final File file;
    private final String uri;

    public FileDocumentSource(File file) {
        this.file = file;
        this.uri = file.toURI().toString();
    }

    public FileDocumentSource(File file, String baseIRI) {
        this.file = file;
        this.uri = baseIRI;
    }

    public InputStream openInputStream() throws IOException {
        return new BufferedInputStream(new FileInputStream(this.file));
    }

    public long getContentLength() {
        return this.file.length();
    }

    public String getDocumentIRI() {
        return this.uri;
    }

    public String getContentType() {
        return null;
    }

    public boolean isLocal() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readStream() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (InputStream is = this.openInputStream();){
            int c;
            while ((c = is.read()) != -1) {
                baos.write(c);
            }
        }
        return new String(baos.toByteArray(), StandardCharsets.UTF_8);
    }
}

