/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.extractor.html.microformats2;

import java.util.List;
import org.apache.any23.extractor.ExtractionException;
import org.apache.any23.extractor.ExtractionResult;
import org.apache.any23.extractor.ExtractorDescription;
import org.apache.any23.extractor.TagSoupExtractionResult;
import org.apache.any23.extractor.html.DomUtils;
import org.apache.any23.extractor.html.EntityBasedMicroformatExtractor;
import org.apache.any23.extractor.html.HTMLDocument;
import org.apache.any23.extractor.html.microformats2.HCardExtractor;
import org.apache.any23.extractor.html.microformats2.HCardExtractorFactory;
import org.apache.any23.extractor.html.microformats2.HEventExtractor;
import org.apache.any23.extractor.html.microformats2.HEventExtractorFactory;
import org.apache.any23.extractor.html.microformats2.HResumeExtractorFactory;
import org.apache.any23.vocab.HResume;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.w3c.dom.Node;

public class HResumeExtractor
extends EntityBasedMicroformatExtractor {
    private static final HResume vResume = HResume.getInstance();
    private static final String[] resumeFields = new String[]{"name", "summary", "contact", "education", "experience", "skill", "affiliation"};

    @Override
    public ExtractorDescription getDescription() {
        return HResumeExtractorFactory.getDescriptionInstance();
    }

    @Override
    public String getBaseClassName() {
        return "h-resume";
    }

    @Override
    protected void resetExtractor() {
    }

    @Override
    protected boolean extractEntity(Node node, ExtractionResult out) throws ExtractionException {
        if (null == node) {
            return false;
        }
        BNode person = this.getBlankNodeFor(node);
        out.writeTriple((Resource)person, RDF.TYPE, (Value)HResumeExtractor.vResume.Resume);
        HTMLDocument fragment = new HTMLDocument(node);
        this.addName(fragment, (Resource)person);
        this.addSummary(fragment, (Resource)person);
        this.addSkills(fragment, (Resource)person);
        this.addExperiences(fragment, (Resource)person);
        this.addEducations(fragment, (Resource)person);
        this.addAffiliations(fragment, (Resource)person);
        this.addContacts(fragment, (Resource)person);
        TagSoupExtractionResult tser = (TagSoupExtractionResult)out;
        tser.addResourceRoot(DomUtils.getXPathListForNode(node), (Resource)person, this.getClass());
        return true;
    }

    private void addContacts(HTMLDocument doc, Resource entry) throws ExtractionException {
        List<Node> nodes = doc.findAllByClassName("p-" + resumeFields[2] + " h-card");
        if (nodes.isEmpty()) {
            return;
        }
        HCardExtractorFactory factory = new HCardExtractorFactory();
        HCardExtractor extractor = factory.createExtractor();
        for (Node node : nodes) {
            BNode contact = this.valueFactory.createBNode();
            this.addIRIProperty((Resource)contact, RDF.TYPE, HResumeExtractor.vResume.contact);
            extractor.extractEntityAsEmbeddedProperty(new HTMLDocument(node), contact, this.getCurrentExtractionResult());
        }
    }

    private void addAffiliations(HTMLDocument doc, Resource entry) throws ExtractionException {
        List<Node> nodes = doc.findAllByClassName("p-" + resumeFields[6] + " h-card");
        if (nodes.isEmpty()) {
            return;
        }
        HCardExtractorFactory factory = new HCardExtractorFactory();
        HCardExtractor extractor = factory.createExtractor();
        for (Node node : nodes) {
            BNode affiliation = this.valueFactory.createBNode();
            this.addIRIProperty((Resource)affiliation, RDF.TYPE, HResumeExtractor.vResume.affiliation);
            extractor.extractEntityAsEmbeddedProperty(new HTMLDocument(node), affiliation, this.getCurrentExtractionResult());
        }
    }

    private void addName(HTMLDocument doc, Resource person) {
        HTMLDocument.TextField name = doc.getSingularTextField("p-" + resumeFields[0]);
        this.conditionallyAddStringProperty(name.source(), person, HResumeExtractor.vResume.name, name.value());
    }

    private void addSummary(HTMLDocument doc, Resource person) {
        HTMLDocument.TextField summary = doc.getSingularTextField("p-" + resumeFields[1]);
        this.conditionallyAddStringProperty(summary.source(), person, HResumeExtractor.vResume.summary, summary.value());
    }

    private void addSkills(HTMLDocument doc, Resource person) {
        HTMLDocument.TextField[] skills;
        for (HTMLDocument.TextField skill : skills = doc.getPluralTextField("p-" + resumeFields[5])) {
            this.conditionallyAddStringProperty(skill.source(), person, HResumeExtractor.vResume.skill, skill.value());
        }
    }

    private void addExperiences(HTMLDocument doc, Resource person) throws ExtractionException {
        List<Node> nodes = doc.findAllByClassName("p-" + resumeFields[4] + " h-event");
        if (nodes.isEmpty()) {
            return;
        }
        HEventExtractorFactory factory = new HEventExtractorFactory();
        HEventExtractor extractor = factory.createExtractor();
        for (Node node : nodes) {
            BNode event = this.valueFactory.createBNode();
            this.addIRIProperty((Resource)event, RDF.TYPE, HResumeExtractor.vResume.experience);
            extractor.extractEntityAsEmbeddedProperty(new HTMLDocument(node), event, this.getCurrentExtractionResult());
        }
    }

    private void addEducations(HTMLDocument doc, Resource person) throws ExtractionException {
        List<Node> nodes = doc.findAllByClassName("p-" + resumeFields[3] + " h-event");
        if (nodes.isEmpty()) {
            return;
        }
        HEventExtractorFactory factory = new HEventExtractorFactory();
        HEventExtractor extractor = factory.createExtractor();
        for (Node node : nodes) {
            BNode event = this.valueFactory.createBNode();
            this.addIRIProperty((Resource)event, RDF.TYPE, HResumeExtractor.vResume.education);
            extractor.extractEntityAsEmbeddedProperty(new HTMLDocument(node), event, this.getCurrentExtractionResult());
        }
    }
}

