/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.extractor.html.microformats2;

import org.apache.any23.extractor.ExtractionException;
import org.apache.any23.extractor.ExtractionResult;
import org.apache.any23.extractor.ExtractorDescription;
import org.apache.any23.extractor.TagSoupExtractionResult;
import org.apache.any23.extractor.html.EntityBasedMicroformatExtractor;
import org.apache.any23.extractor.html.HTMLDocument;
import org.apache.any23.extractor.html.microformats2.HAdrExtractorFactory;
import org.apache.any23.extractor.html.microformats2.HGeoExtractor;
import org.apache.any23.extractor.html.microformats2.annotations.Includes;
import org.apache.any23.vocab.VCard;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.w3c.dom.Node;

@Includes(extractors={HGeoExtractor.class})
public class HAdrExtractor
extends EntityBasedMicroformatExtractor {
    private static final VCard vVCARD = VCard.getInstance();
    private static final String[] addressFields = new String[]{"street-address", "extended-address", "locality", "region", "postal-code", "country-name", "geo"};
    private static final String[] geoFields = new String[]{"latitude", "longitude", "altitude"};

    @Override
    protected String getBaseClassName() {
        return "h-adr";
    }

    @Override
    protected void resetExtractor() {
    }

    @Override
    protected boolean extractEntity(Node node, ExtractionResult out) throws ExtractionException {
        if (null == node) {
            return false;
        }
        HTMLDocument document = new HTMLDocument(node);
        BNode adr = this.getBlankNodeFor(node);
        out.writeTriple((Resource)adr, RDF.TYPE, (Value)HAdrExtractor.vVCARD.Address);
        String extractorName = this.getDescription().getExtractorName();
        for (String field : addressFields) {
            HTMLDocument.TextField[] values;
            for (HTMLDocument.TextField val : values = document.getPluralTextField("p-" + field)) {
                if (!field.equals("geo")) {
                    this.conditionallyAddStringProperty(val.source(), (Resource)adr, vVCARD.getProperty(field), val.value());
                    continue;
                }
                String[] composed = val.value().split(";");
                for (int counter = 0; counter < composed.length; ++counter) {
                    this.conditionallyAddStringProperty(val.source(), (Resource)adr, vVCARD.getProperty(geoFields[counter]), composed[counter]);
                }
            }
        }
        this.addGeoAsUrlResource((Resource)adr, document);
        TagSoupExtractionResult tser = (TagSoupExtractionResult)this.getCurrentExtractionResult();
        tser.addResourceRoot(document.getPathToLocalRoot(), (Resource)adr, this.getClass());
        return true;
    }

    private void addGeoAsUrlResource(Resource card, HTMLDocument document) throws ExtractionException {
        HTMLDocument.TextField[] links;
        for (HTMLDocument.TextField link : links = document.getPluralUrlField("u-geo")) {
            this.conditionallyAddResourceProperty(card, HAdrExtractor.vVCARD.geo, this.getHTMLDocument().resolveIRI(link.value()));
        }
    }

    @Override
    public ExtractorDescription getDescription() {
        return HAdrExtractorFactory.getDescriptionInstance();
    }
}

