/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.content;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.sis.internal.jaxb.FilterByVersion;
import org.apache.sis.internal.jaxb.gmi.MI_CoverageDescription;
import org.apache.sis.internal.jaxb.metadata.MD_Identifier;
import org.apache.sis.internal.metadata.Dependencies;
import org.apache.sis.internal.metadata.MetadataUtilities;
import org.apache.sis.internal.metadata.legacy.LegacyPropertyAdapter;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.metadata.iso.content.AbstractContentInformation;
import org.apache.sis.metadata.iso.content.DefaultAttributeGroup;
import org.apache.sis.metadata.iso.content.DefaultImageDescription;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.content.CoverageContentType;
import org.opengis.metadata.content.CoverageDescription;
import org.opengis.metadata.content.ImageDescription;
import org.opengis.metadata.content.RangeDimension;
import org.opengis.metadata.content.RangeElementDescription;
import org.opengis.util.RecordType;

@XmlType(name="MD_CoverageDescription_Type", propOrder={"attributeDescription", "processingLevelCode", "attributeGroup", "contentType", "dimensions", "rangeElementDescriptions"})
@XmlRootElement(name="MD_CoverageDescription")
@XmlSeeAlso(value={DefaultImageDescription.class, MI_CoverageDescription.class})
public class DefaultCoverageDescription
extends AbstractContentInformation
implements CoverageDescription {
    private static final long serialVersionUID = 2161065580202989466L;
    private RecordType attributeDescription;
    private Identifier processingLevelCode;
    private Collection<DefaultAttributeGroup> attributeGroups;
    private Collection<RangeElementDescription> rangeElementDescriptions;

    public DefaultCoverageDescription() {
    }

    public DefaultCoverageDescription(CoverageDescription coverageDescription) {
        super(coverageDescription);
        if (coverageDescription != null) {
            this.attributeDescription = coverageDescription.getAttributeDescription();
            this.rangeElementDescriptions = this.copyCollection(coverageDescription.getRangeElementDescriptions(), RangeElementDescription.class);
            if (coverageDescription instanceof DefaultCoverageDescription) {
                this.processingLevelCode = ((DefaultCoverageDescription)coverageDescription).getProcessingLevelCode();
                this.attributeGroups = this.copyCollection(((DefaultCoverageDescription)coverageDescription).getAttributeGroups(), DefaultAttributeGroup.class);
            }
        }
    }

    public static DefaultCoverageDescription castOrCopy(CoverageDescription coverageDescription) {
        if (coverageDescription instanceof ImageDescription) {
            return DefaultImageDescription.castOrCopy((ImageDescription)coverageDescription);
        }
        if (coverageDescription == null || coverageDescription instanceof DefaultCoverageDescription) {
            return (DefaultCoverageDescription)coverageDescription;
        }
        return new DefaultCoverageDescription(coverageDescription);
    }

    @Override
    @XmlElement(name="attributeDescription", required=true)
    public RecordType getAttributeDescription() {
        return this.attributeDescription;
    }

    public void setAttributeDescription(RecordType recordType) {
        this.checkWritePermission(this.attributeDescription);
        this.attributeDescription = recordType;
    }

    @XmlElement(name="processingLevelCode")
    @XmlJavaTypeAdapter(value=MD_Identifier.Since2014.class)
    @UML(identifier="processingLevelCode", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Identifier getProcessingLevelCode() {
        return this.processingLevelCode;
    }

    public void setProcessingLevelCode(Identifier identifier) {
        this.checkWritePermission(this.processingLevelCode);
        this.processingLevelCode = identifier;
    }

    @UML(identifier="attributeGroup", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<DefaultAttributeGroup> getAttributeGroups() {
        this.attributeGroups = this.nonNullCollection(this.attributeGroups, DefaultAttributeGroup.class);
        return this.attributeGroups;
    }

    public void setAttributeGroups(Collection<? extends DefaultAttributeGroup> collection) {
        this.attributeGroups = this.writeCollection(collection, this.attributeGroups, DefaultAttributeGroup.class);
    }

    @Override
    @Deprecated
    @Dependencies(value={"getAttributeGroups"})
    @XmlElement(name="contentType", namespace="http://www.isotc211.org/2005/gmd")
    public CoverageContentType getContentType() {
        Collection<DefaultAttributeGroup> collection;
        CoverageContentType coverageContentType = null;
        if (FilterByVersion.LEGACY_METADATA.accept() && (collection = this.getAttributeGroups()) != null) {
            block0: for (DefaultAttributeGroup defaultAttributeGroup : collection) {
                Collection<CoverageContentType> collection2 = defaultAttributeGroup.getContentTypes();
                if (collection2 == null) continue;
                for (CoverageContentType coverageContentType2 : collection2) {
                    if (coverageContentType == null) {
                        coverageContentType = coverageContentType2;
                        continue;
                    }
                    LegacyPropertyAdapter.warnIgnoredExtraneous(CoverageContentType.class, DefaultCoverageDescription.class, "getContentType");
                    continue block0;
                }
            }
        }
        return coverageContentType;
    }

    @Deprecated
    public void setContentType(CoverageContentType coverageContentType) {
        Object object;
        this.checkWritePermission(MetadataUtilities.valueIfDefined(this.attributeGroups));
        Set<CoverageContentType> set = CollectionsExt.singletonOrEmpty(coverageContentType);
        Collection<DefaultAttributeGroup> collection = this.attributeGroups;
        if (collection != null && (object = collection.iterator()).hasNext()) {
            DefaultAttributeGroup defaultAttributeGroup = (DefaultAttributeGroup)object.next();
            defaultAttributeGroup.setContentTypes(set);
            return;
        }
        object = new DefaultAttributeGroup();
        ((DefaultAttributeGroup)object).setContentTypes(set);
        if (collection != null) {
            collection.add((DefaultAttributeGroup)object);
        } else {
            collection = Collections.singleton(object);
        }
        this.setAttributeGroups(collection);
    }

    @Deprecated
    @Dependencies(value={"getAttributeGroups"})
    @XmlElement(name="dimension", namespace="http://www.isotc211.org/2005/gmd")
    public final Collection<RangeDimension> getDimensions() {
        if (!FilterByVersion.LEGACY_METADATA.accept()) {
            return null;
        }
        return new LegacyPropertyAdapter<RangeDimension, DefaultAttributeGroup>(this.getAttributeGroups()){

            @Override
            protected DefaultAttributeGroup wrap(RangeDimension rangeDimension) {
                DefaultAttributeGroup defaultAttributeGroup = new DefaultAttributeGroup();
                defaultAttributeGroup.setAttributes(CollectionsExt.singletonOrEmpty(rangeDimension));
                return defaultAttributeGroup;
            }

            @Override
            protected RangeDimension unwrap(DefaultAttributeGroup defaultAttributeGroup) {
                return 1.getSingleton(defaultAttributeGroup.getAttributes(), RangeDimension.class, this, DefaultCoverageDescription.class, "getDimensions");
            }

            @Override
            protected boolean update(DefaultAttributeGroup defaultAttributeGroup, RangeDimension rangeDimension) {
                if (defaultAttributeGroup instanceof DefaultAttributeGroup) {
                    defaultAttributeGroup.setAttributes(CollectionsExt.singletonOrEmpty(rangeDimension));
                    return true;
                }
                return false;
            }
        }.validOrNull();
    }

    @Deprecated
    public void setDimensions(Collection<? extends RangeDimension> collection) {
        this.checkWritePermission(MetadataUtilities.valueIfDefined(this.attributeGroups));
        ((LegacyPropertyAdapter)this.getDimensions()).setValues(collection);
    }

    @XmlElement(name="rangeElementDescription")
    public Collection<RangeElementDescription> getRangeElementDescriptions() {
        this.rangeElementDescriptions = this.nonNullCollection(this.rangeElementDescriptions, RangeElementDescription.class);
        return this.rangeElementDescriptions;
    }

    public void setRangeElementDescriptions(Collection<? extends RangeElementDescription> collection) {
        this.rangeElementDescriptions = this.writeCollection(collection, this.rangeElementDescriptions, RangeElementDescription.class);
    }

    @XmlElement(name="attributeGroup")
    private Collection<DefaultAttributeGroup> getAttributeGroup() {
        return FilterByVersion.CURRENT_METADATA.accept() ? this.getAttributeGroups() : null;
    }
}

