/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.cli;

import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.converters.FileConverter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Objects;
import org.apache.any23.Any23;
import org.apache.any23.cli.BaseTool;
import org.apache.any23.configuration.Configuration;
import org.apache.any23.configuration.DefaultConfiguration;
import org.apache.any23.configuration.Setting;
import org.apache.any23.configuration.Settings;
import org.apache.any23.extractor.ExtractionParameters;
import org.apache.any23.extractor.ExtractorRegistry;
import org.apache.any23.extractor.ExtractorRegistryImpl;
import org.apache.any23.filter.IgnoreAccidentalRDFa;
import org.apache.any23.filter.IgnoreTitlesOfEmptyDocuments;
import org.apache.any23.source.DocumentSource;
import org.apache.any23.writer.BenchmarkTripleHandler;
import org.apache.any23.writer.DecoratingWriterFactory;
import org.apache.any23.writer.LoggingTripleHandler;
import org.apache.any23.writer.ReportingTripleHandler;
import org.apache.any23.writer.TripleHandler;
import org.apache.any23.writer.TripleHandlerException;
import org.apache.any23.writer.TripleWriterFactory;
import org.apache.any23.writer.WriterFactory;
import org.apache.any23.writer.WriterFactoryRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Parameters(commandNames={"rover"}, commandDescription="Apache Any23 Command Line Tool.")
public class Rover
extends BaseTool {
    private static final Logger logger = LoggerFactory.getLogger(Rover.class);
    private static final ExtractorRegistry eRegistry = ExtractorRegistryImpl.getInstance();
    private static final WriterFactoryRegistry registry = WriterFactoryRegistry.getInstance();
    private static final String DEFAULT_WRITER_IDENTIFIER = "ntriples";
    @Parameter(names={"-o", "--output"}, description="Specify Output file (defaults to standard output)", converter=PrintStreamConverter.class)
    private PrintStream outputStream = System.out;
    @Parameter(description="input IRIs {<url>|<file>}+", converter=ArgumentToIRIConverter.class)
    protected List<String> inputIRIs = new LinkedList<String>();
    @Parameter(names={"-e", "--extractors"}, description="a comma-separated list of extractors, e.g. rdf-xml,rdf-turtle, etc. A complete extractor list can be obtained by calling ./any23 extractor --list")
    private List<String> extractors = new LinkedList<String>(){
        {
            this.addAll(eRegistry.getAllNames());
        }
    };
    @Parameter(names={"-f", "--format"}, description="a comma-separated list of writer factories, e.g. json,jsonld,nquads,notrivial,ntriples,trix,turtle,uri")
    private List<String> formats = new LinkedList<String>(){
        {
            this.add(Rover.DEFAULT_WRITER_IDENTIFIER);
        }
    };
    @Parameter(names={"-l", "--log"}, description="Produce log within a file.", converter=FileConverter.class)
    private File logFile = null;
    @Parameter(names={"-s", "--stats"}, description="Print out extraction statistics.")
    private boolean statistics;
    @Parameter(names={"-t", "--notrivial"}, description="Filter trivial statements (e.g. CSS related ones). [DEPRECATED: As of version 2.3, use --format instead.]")
    private boolean noTrivial;
    @Parameter(names={"-p", "--pedantic"}, description="Validate and fixes HTML content detecting commons issues.")
    private boolean pedantic;
    @Parameter(names={"-n", "--nesting"}, description="Disable production of nesting triples.")
    private boolean nestingDisabled;
    @Parameter(names={"-d", "--defaultns"}, description="Override the default namespace used to produce statements.")
    private String defaultns;
    private TripleHandler tripleHandler;
    private ReportingTripleHandler reportingTripleHandler;
    private BenchmarkTripleHandler benchmarkTripleHandler;
    private Any23 any23;
    private ExtractionParameters extractionParameters;

    @Override
    PrintStream getOut() {
        return this.outputStream;
    }

    @Override
    void setOut(PrintStream out) {
        this.outputStream = out;
    }

    private static TripleHandler getWriter(String id, OutputStream os) {
        TripleWriterFactory f = (TripleWriterFactory)registry.getWriterByIdentifier(id);
        Objects.requireNonNull(f, () -> "Invalid writer id '" + id + "'; admitted values: " + registry.getIdentifiers());
        return f.getTripleWriter(os, Settings.of());
    }

    private static TripleHandler getWriter(String id, TripleHandler delegate) {
        DecoratingWriterFactory f = (DecoratingWriterFactory)registry.getWriterByIdentifier(id);
        Objects.requireNonNull(f, () -> "Invalid writer id '" + id + "'; admitted values: " + registry.getIdentifiers());
        return f.getTripleWriter(delegate, Settings.of());
    }

    protected void configure() {
        List<String> formats = this.formats;
        if (formats.isEmpty()) {
            formats = Collections.singletonList(DEFAULT_WRITER_IDENTIFIER);
        }
        ListIterator<String> l = formats.listIterator(formats.size());
        this.tripleHandler = Rover.getWriter(l.previous(), this.outputStream);
        while (l.hasPrevious()) {
            this.tripleHandler = Rover.getWriter(l.previous(), this.tripleHandler);
        }
        if (this.logFile != null) {
            try {
                this.tripleHandler = new LoggingTripleHandler(this.tripleHandler, new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.logFile), StandardCharsets.UTF_8)));
            }
            catch (FileNotFoundException fnfe) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "Can not write to log file [%s]", this.logFile), fnfe);
            }
        }
        if (this.statistics) {
            this.benchmarkTripleHandler = new BenchmarkTripleHandler(this.tripleHandler);
            this.tripleHandler = this.benchmarkTripleHandler;
        }
        if (this.noTrivial) {
            this.tripleHandler = new IgnoreAccidentalRDFa((TripleHandler)new IgnoreTitlesOfEmptyDocuments(this.tripleHandler), true);
        }
        this.reportingTripleHandler = new ReportingTripleHandler(this.tripleHandler);
        DefaultConfiguration configuration = DefaultConfiguration.singleton();
        ExtractionParameters extractionParameters = this.extractionParameters = this.pedantic ? new ExtractionParameters((Configuration)configuration, ExtractionParameters.ValidationMode.VALIDATE_AND_FIX, this.nestingDisabled) : new ExtractionParameters((Configuration)configuration, ExtractionParameters.ValidationMode.NONE, this.nestingDisabled);
        if (this.defaultns != null) {
            this.extractionParameters.setProperty("any23.extraction.context.iri", this.defaultns);
        }
        this.any23 = this.extractors.isEmpty() ? new Any23() : new Any23(this.extractors.toArray(new String[this.extractors.size()]));
        this.any23.setHTTPUserAgent(Any23.DEFAULT_HTTP_CLIENT_USER_AGENT + "/" + Any23.VERSION);
    }

    protected String printReports() {
        StringBuilder sb = new StringBuilder();
        if (this.benchmarkTripleHandler != null) {
            sb.append(this.benchmarkTripleHandler.report()).append('\n');
        }
        if (this.reportingTripleHandler != null) {
            sb.append(this.reportingTripleHandler.printReport()).append('\n');
        }
        return sb.toString();
    }

    protected void performExtraction(DocumentSource documentSource) throws Exception {
        if (!this.any23.extract(this.extractionParameters, documentSource, (TripleHandler)this.reportingTripleHandler).hasMatchingExtractors()) {
            throw new IllegalStateException(String.format(Locale.ROOT, "No suitable extractors found for source %s", documentSource.getDocumentIRI()));
        }
    }

    protected void close() {
        if (this.tripleHandler != null) {
            try {
                this.tripleHandler.close();
            }
            catch (TripleHandlerException the) {
                throw new RuntimeException("Error while closing TripleHandler", the);
            }
        }
        if (this.outputStream != null && this.outputStream != System.out) {
            this.outputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Exception {
        if (this.inputIRIs.isEmpty()) {
            throw new IllegalArgumentException("Expected at least 1 argument.");
        }
        this.configure();
        try {
            long start = System.currentTimeMillis();
            for (String inputIRI : this.inputIRIs) {
                DocumentSource source = this.any23.createDocumentSource(inputIRI);
                this.performExtraction(source);
            }
            long elapsed = System.currentTimeMillis() - start;
            if (this.benchmarkTripleHandler != null) {
                System.err.println(this.benchmarkTripleHandler.report());
            }
            logger.info("Extractors used: " + this.reportingTripleHandler.getExtractorNames());
            logger.info(this.reportingTripleHandler.getTotalTriples() + " triples, " + elapsed + "ms");
        }
        finally {
            this.close();
        }
    }

    static {
        final Setting ALWAYS_SUPPRESS_CSS_TRIPLES = Setting.create((String)"alwayssuppresscsstriples", (Boolean)Boolean.TRUE);
        final Settings supportedSettings = Settings.of((Setting)ALWAYS_SUPPRESS_CSS_TRIPLES);
        registry.register((WriterFactory)new DecoratingWriterFactory(){

            public TripleHandler getTripleWriter(TripleHandler delegate, Settings settings) {
                boolean always = (Boolean)settings.get(ALWAYS_SUPPRESS_CSS_TRIPLES);
                return new IgnoreAccidentalRDFa((TripleHandler)new IgnoreTitlesOfEmptyDocuments(delegate), always);
            }

            public Settings getSupportedSettings() {
                return supportedSettings;
            }

            public String getIdentifier() {
                return "notrivial";
            }
        });
    }

    public static final class PrintStreamConverter
    implements IStringConverter<PrintStream> {
        public PrintStream convert(String value) {
            File file = new File(value);
            try {
                return new PrintStream((OutputStream)new FileOutputStream(file), true, "UTF-8");
            }
            catch (FileNotFoundException fnfe) {
                throw new ParameterException(String.format(Locale.ROOT, "Cannot open file '%s': %s", file, fnfe.getMessage()));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Error converting to PrintStream with UTF-8 encoding.", e);
            }
        }
    }

    public static final class ArgumentToIRIConverter
    implements IStringConverter<String> {
        public String convert(String uri) {
            if ((uri = uri.trim()).toLowerCase(Locale.ROOT).startsWith("http:") || uri.toLowerCase(Locale.ROOT).startsWith("https:")) {
                try {
                    return new URL(uri).toString();
                }
                catch (MalformedURLException murle) {
                    throw new ParameterException(String.format(Locale.ROOT, "Invalid IRI: '%s': %s", uri, murle.getMessage()));
                }
            }
            File f = new File(uri);
            if (!f.exists()) {
                throw new ParameterException(String.format(Locale.ROOT, "No such file: [%s]", f.getAbsolutePath()));
            }
            if (f.isDirectory()) {
                throw new ParameterException(String.format(Locale.ROOT, "Found a directory: [%s]", f.getAbsolutePath()));
            }
            return f.toURI().toString();
        }
    }
}

